/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.client.internal.json;

import com.atlassian.jira.rest.client.domain.AssigneeType;
import com.atlassian.jira.rest.client.domain.BasicComponent;
import com.atlassian.jira.rest.client.domain.BasicUser;
import com.atlassian.jira.rest.client.domain.Component;
import com.atlassian.jira.rest.client.internal.json.BasicComponentJsonParser;
import com.atlassian.jira.rest.client.internal.json.JsonParseUtil;
import com.atlassian.jira.rest.client.internal.json.JsonParser;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

public class ComponentJsonParser
implements JsonParser<Component> {
    @Override
    public Component parse(JSONObject json) throws JSONException {
        Component.AssigneeInfo assigneeInfo;
        BasicComponent basicComponent = BasicComponentJsonParser.parseBasicComponent(json);
        JSONObject leadJson = json.optJSONObject("lead");
        BasicUser lead = leadJson != null ? JsonParseUtil.parseBasicUser(leadJson) : null;
        String assigneeTypeStr = JsonParseUtil.getOptionalString(json, "assigneeType");
        if (assigneeTypeStr != null) {
            AssigneeType assigneeType = this.parseAssigneeType(assigneeTypeStr);
            JSONObject assigneeJson = json.optJSONObject("assignee");
            BasicUser assignee = assigneeJson != null ? JsonParseUtil.parseBasicUser(assigneeJson) : null;
            AssigneeType realAssigneeType = this.parseAssigneeType(json.getString("realAssigneeType"));
            JSONObject realAssigneeJson = json.optJSONObject("realAssignee");
            BasicUser realAssignee = realAssigneeJson != null ? JsonParseUtil.parseBasicUser(realAssigneeJson) : null;
            boolean isAssigneeTypeValid = json.getBoolean("isAssigneeTypeValid");
            assigneeInfo = new Component.AssigneeInfo(assignee, assigneeType, realAssignee, realAssigneeType, isAssigneeTypeValid);
        } else {
            assigneeInfo = null;
        }
        return new Component(basicComponent.getSelf(), basicComponent.getName(), basicComponent.getDescription(), lead, assigneeInfo);
    }

    AssigneeType parseAssigneeType(String str) throws JSONException {
        if ("COMPONENT_LEAD".equals(str)) {
            return AssigneeType.COMPONENT_LEAD;
        }
        if ("PROJECT_DEFAULT".equals(str)) {
            return AssigneeType.PROJECT_DEFAULT;
        }
        if ("PROJECT_LEAD".equals(str)) {
            return AssigneeType.PROJECT_LEAD;
        }
        if ("UNASSIGNED".equals(str)) {
            return AssigneeType.UNASSIGNED;
        }
        throw new JSONException("Unexpected value of assignee type [" + str + "]");
    }
}

