/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.client.internal.json;

import com.atlassian.jira.rest.client.domain.Attachment;
import com.atlassian.jira.rest.client.domain.BasicUser;
import com.atlassian.jira.rest.client.internal.json.JsonParseUtil;
import com.atlassian.jira.rest.client.internal.json.JsonParser;
import java.net.URI;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.joda.time.DateTime;

public class AttachmentJsonParser
implements JsonParser<Attachment> {
    private static final String THUMBNAIL = "thumbnail";

    @Override
    public Attachment parse(JSONObject json) throws JSONException {
        URI selfUri = JsonParseUtil.getSelfUri(json);
        String filename = json.getString("filename");
        BasicUser author = JsonParseUtil.parseBasicUser(json.getJSONObject("author"));
        DateTime creationDate = JsonParseUtil.parseDateTime(json.getString("created"));
        int size = json.getInt("size");
        String mimeType = json.getString("mimeType");
        URI contentURI = JsonParseUtil.parseURI(json.getString("content"));
        URI thumbnailURI = JsonParseUtil.parseOptionalURI(json, THUMBNAIL);
        return new Attachment(selfUri, filename, author, creationDate, size, mimeType, contentURI, thumbnailURI);
    }
}

