/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.client.internal.jersey;

import com.atlassian.jira.rest.client.MetadataRestClient;
import com.atlassian.jira.rest.client.ProgressMonitor;
import com.atlassian.jira.rest.client.domain.IssueType;
import com.atlassian.jira.rest.client.domain.Priority;
import com.atlassian.jira.rest.client.domain.Resolution;
import com.atlassian.jira.rest.client.domain.ServerInfo;
import com.atlassian.jira.rest.client.domain.Status;
import com.atlassian.jira.rest.client.internal.jersey.AbstractJerseyRestClient;
import com.atlassian.jira.rest.client.internal.json.IssueTypeJsonParser;
import com.atlassian.jira.rest.client.internal.json.PriorityJsonParser;
import com.atlassian.jira.rest.client.internal.json.ResolutionJsonParser;
import com.atlassian.jira.rest.client.internal.json.ServerInfoJsonParser;
import com.atlassian.jira.rest.client.internal.json.StatusJsonParser;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.client.apache.ApacheHttpClient;
import java.net.URI;
import java.util.concurrent.Callable;
import javax.ws.rs.core.UriBuilder;
import org.codehaus.jettison.json.JSONObject;

public class JerseyMetadataRestClient
extends AbstractJerseyRestClient
implements MetadataRestClient {
    private final String SERVER_INFO_RESOURCE = "/serverInfo";
    private final ServerInfoJsonParser serverInfoJsonParser = new ServerInfoJsonParser();
    private final IssueTypeJsonParser issueTypeJsonParser = new IssueTypeJsonParser();
    private final StatusJsonParser statusJsonParser = new StatusJsonParser();
    private final PriorityJsonParser priorityJsonParser = new PriorityJsonParser();
    private final ResolutionJsonParser resolutionJsonParser = new ResolutionJsonParser();

    public JerseyMetadataRestClient(URI baseUri, ApacheHttpClient client) {
        super(baseUri, client);
    }

    @Override
    public IssueType getIssueType(URI uri, ProgressMonitor progressMonitor) {
        return this.getAndParse(uri, this.issueTypeJsonParser, progressMonitor);
    }

    @Override
    public Status getStatus(URI uri, ProgressMonitor progressMonitor) {
        return this.getAndParse(uri, this.statusJsonParser, progressMonitor);
    }

    @Override
    public Priority getPriority(URI uri, ProgressMonitor progressMonitor) {
        return this.getAndParse(uri, this.priorityJsonParser, progressMonitor);
    }

    @Override
    public Resolution getResolution(URI uri, ProgressMonitor progressMonitor) {
        return this.getAndParse(uri, this.resolutionJsonParser, progressMonitor);
    }

    @Override
    public ServerInfo getServerInfo(ProgressMonitor progressMonitor) {
        return this.invoke(new Callable<ServerInfo>(){

            @Override
            public ServerInfo call() throws Exception {
                WebResource serverInfoResource = JerseyMetadataRestClient.this.client.resource(UriBuilder.fromUri((URI)JerseyMetadataRestClient.this.baseUri).path("/serverInfo").build(new Object[0]));
                return JerseyMetadataRestClient.this.serverInfoJsonParser.parse((JSONObject)serverInfoResource.get(JSONObject.class));
            }
        });
    }
}

