/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.client;

import com.atlassian.jira.rest.client.api.RestClientException;
import com.atlassian.jira.rest.client.api.domain.OperationGroup;
import com.atlassian.jira.rest.client.api.domain.OperationLink;
import com.atlassian.jira.rest.client.api.domain.Transition;
import com.atlassian.jira.rest.client.api.domain.util.ErrorCollection;
import com.google.common.collect.Iterators;
import jakarta.annotation.Nullable;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriBuilder;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import org.apache.commons.lang.StringUtils;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;
import org.junit.Assert;

public class TestUtil {
    private static DateTimeFormatter universalDateTimeParser = ISODateTimeFormat.dateTimeParser();
    private static DateTimeFormatter formatter = ISODateTimeFormat.dateTime();
    private static DateTimeFormatter dateFormatter = ISODateTimeFormat.date();
    public static Iterable<OperationGroup> EMPTY_GROUPS = Collections.emptyList();
    public static Iterable<OperationLink> EMPTY_LINKS = Collections.emptyList();

    public static URI toUri(String str) {
        return UriBuilder.fromUri((String)str).build(new Object[0]);
    }

    public static DateTime toDateTime(String isoDateTimeSt) {
        return universalDateTimeParser.parseDateTime(isoDateTimeSt);
    }

    public static DateTime toDateTime(String isoDateTimeSt, DateTimeZone zone) {
        return formatter.withZone(zone).parseDateTime(isoDateTimeSt);
    }

    public static DateTime toDateTimeFromIsoDate(String isoDate) {
        return dateFormatter.parseDateTime(isoDate);
    }

    public static void assertErrorCode(int errorCode, Runnable runnable) {
        TestUtil.assertErrorCode(errorCode, "", runnable);
    }

    public static <T extends Throwable> void assertThrows(Class<T> clazz, String regexp, Runnable runnable) {
        block3: {
            try {
                runnable.run();
                junit.framework.Assert.fail((String)(clazz.getName() + " exception expected"));
            }
            catch (Throwable e) {
                junit.framework.Assert.assertTrue((String)("Expected exception of class " + clazz.getName() + " but was caught " + e.getClass().getName()), (boolean)clazz.isInstance(e));
                if (e.getMessage() == null && regexp != null) {
                    junit.framework.Assert.fail((String)("Exception with no message caught, while expected regexp [" + regexp + "]"));
                }
                if (regexp == null || e.getMessage() == null) break block3;
                junit.framework.Assert.assertTrue((String)("Message [" + e.getMessage() + "] does not match regexp [" + regexp + "]"), (boolean)e.getMessage().matches(regexp));
            }
        }
    }

    public static void assertErrorCode(Response.Status status, String message, Runnable runnable) {
        TestUtil.assertErrorCode(status.getStatusCode(), message, runnable);
    }

    public static void assertExpectedErrorCollection(Collection<ErrorCollection> errors, Runnable runnable) {
        TestUtil.assertExpectedErrors(errors, runnable);
    }

    public static void assertErrorCodeWithRegexp(Response.Status status, String regexp, Runnable runnable) {
        TestUtil.assertErrorCodeWithRegexp(status.getStatusCode(), regexp, runnable);
    }

    public static void assertErrorCode(Response.Status status, Runnable runnable) {
        TestUtil.assertErrorCode(status.getStatusCode(), null, runnable);
    }

    public static void assertErrorCode(int errorCode, String message, Runnable runnable) {
        block4: {
            try {
                runnable.run();
                junit.framework.Assert.fail((String)(String.valueOf(RestClientException.class) + " exception expected"));
            }
            catch (RestClientException e) {
                junit.framework.Assert.assertTrue((boolean)e.getStatusCode().isPresent());
                junit.framework.Assert.assertEquals((int)errorCode, (int)((Integer)e.getStatusCode().get()));
                if (StringUtils.isEmpty((String)message)) break block4;
                junit.framework.Assert.assertEquals((int)1, (int)e.getErrorCollections().size());
                if (((ErrorCollection)Iterators.getOnlyElement(e.getErrorCollections().iterator())).getErrorMessages().size() > 0) {
                    junit.framework.Assert.assertEquals((String)((String)Iterators.getOnlyElement(((ErrorCollection)Iterators.getOnlyElement(e.getErrorCollections().iterator())).getErrorMessages().iterator())), (String)message);
                }
                if (((ErrorCollection)Iterators.getOnlyElement(e.getErrorCollections().iterator())).getErrors().size() > 0) {
                    junit.framework.Assert.assertEquals((String)((String)Iterators.getOnlyElement(((ErrorCollection)Iterators.getOnlyElement(e.getErrorCollections().iterator())).getErrors().values().iterator())), (String)message);
                }
                junit.framework.Assert.fail((String)"Expected an error message.");
            }
        }
    }

    public static void assertErrorCodeWithRegexp(int errorCode, String regExp, Runnable runnable) {
        try {
            runnable.run();
            junit.framework.Assert.fail((String)(String.valueOf(RestClientException.class) + " exception expected"));
        }
        catch (RestClientException ex) {
            ErrorCollection errorElement = (ErrorCollection)Iterators.getOnlyElement(ex.getErrorCollections().iterator());
            String errorMessage = (String)Iterators.getOnlyElement(errorElement.getErrorMessages().iterator());
            junit.framework.Assert.assertTrue((String)("'" + ex.getMessage() + "' does not match regexp '" + regExp + "'"), (boolean)errorMessage.matches(regExp));
            junit.framework.Assert.assertTrue((boolean)ex.getStatusCode().isPresent());
            junit.framework.Assert.assertEquals((int)errorCode, (int)((Integer)ex.getStatusCode().get()));
        }
    }

    public static String getLastPathSegment(URI uri) {
        String path = uri.getPath();
        int index = path.lastIndexOf(47);
        if (index == -1) {
            return path;
        }
        if (index == path.length()) {
            return "";
        }
        return path.substring(index + 1);
    }

    public static <E> void assertEqualsSymmetrical(E a, E b) {
        junit.framework.Assert.assertEquals(a, b);
        junit.framework.Assert.assertEquals(b, a);
    }

    public static <E> void assertNotEquals(E a, E b) {
        if (a == null) {
            junit.framework.Assert.assertFalse((String)("[" + String.valueOf(a) + "] not equals [" + String.valueOf(b) + "]"), (boolean)b.equals(a));
        } else if (b == null) {
            junit.framework.Assert.assertFalse((String)("[" + String.valueOf(a) + "] not equals [" + String.valueOf(b) + "]"), (boolean)a.equals(b));
        } else if (a.equals(b) || b.equals(a)) {
            junit.framework.Assert.fail((String)("[" + String.valueOf(a) + "] not equals [" + String.valueOf(b) + "]"));
        }
    }

    @Nullable
    public static Transition getTransitionByName(Iterable<Transition> transitions, String transitionName) {
        Transition transitionFound = null;
        for (Transition transition : transitions) {
            if (!transition.getName().equals(transitionName)) continue;
            transitionFound = transition;
            break;
        }
        return transitionFound;
    }

    private static void assertExpectedErrors(Collection<ErrorCollection> expectedErrors, Runnable runnable) {
        try {
            runnable.run();
            junit.framework.Assert.fail((String)(String.valueOf(RestClientException.class) + " exception expected"));
        }
        catch (RestClientException e) {
            junit.framework.Assert.assertEquals((Object)e.getErrorCollections(), expectedErrors);
        }
    }

    public static <K> void assertEmptyIterable(Iterable<K> iterable) {
        Assert.assertThat(iterable, (Matcher)Matchers.emptyIterable());
    }
}

