/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.client.test.matchers;

import java.net.URI;
import java.util.regex.Pattern;
import org.hamcrest.Description;
import org.junit.internal.matchers.TypeSafeMatcher;

public class UriRegularExpressionMatcher
extends TypeSafeMatcher<URI> {
    private final URI baseUri;
    private final Pattern pattern;

    public UriRegularExpressionMatcher(URI baseUri, Pattern pattern) {
        this.baseUri = baseUri;
        this.pattern = pattern;
    }

    public static UriRegularExpressionMatcher uriMatchesRegexp(URI baseUri, Pattern pattern) {
        return new UriRegularExpressionMatcher(baseUri, pattern);
    }

    public static UriRegularExpressionMatcher uriMatchesRegexp(URI baseUri, String pattern) {
        return new UriRegularExpressionMatcher(baseUri, Pattern.compile(pattern));
    }

    public boolean matchesSafely(URI given) {
        return this.checkBaseUri(given) && this.checkPattern(given);
    }

    private boolean checkPattern(URI given) {
        URI relativeUrl = this.baseUri.relativize(given);
        return this.pattern.matcher(relativeUrl.toString()).matches();
    }

    private boolean checkBaseUri(URI given) {
        return given.toString().startsWith(this.baseUri.toString());
    }

    public void describeTo(Description description) {
        description.appendText(String.format("url with base %s and matching regular expression %s", this.baseUri, this.pattern));
    }
}

