/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.client;

import com.atlassian.jira.rest.client.TestUtil;
import com.atlassian.jira.rest.client.api.AuthenticationHandler;
import com.atlassian.jira.rest.client.api.JiraRestClient;
import com.atlassian.jira.rest.client.api.domain.BasicUser;
import com.atlassian.jira.rest.client.api.domain.ServerInfo;
import com.atlassian.jira.rest.client.api.domain.User;
import com.atlassian.jira.rest.client.auth.BasicHttpAuthenticationHandler;
import com.atlassian.jira.rest.client.internal.async.AsynchronousJiraRestClientFactory;
import com.atlassian.jira.webtests.util.LocalTestEnvironmentData;
import com.google.common.collect.ImmutableMap;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import javax.annotation.Nullable;
import javax.ws.rs.core.UriBuilder;
import org.apache.commons.lang.StringUtils;

public class IntegrationTestUtil {
    public static final User USER_ADMIN_FULL;
    public static final BasicUser USER_ADMIN;
    public static final BasicUser USER_ADMIN_LATEST;
    public static final User USER1_FULL;
    public static final BasicUser USER1;
    public static final BasicUser USER2;
    public static final BasicUser USER1_LATEST;
    public static final BasicUser USER2_LATEST;
    public static final BasicUser USER_SLASH;
    public static final BasicUser USER_SLASH_LATEST;
    public static final BasicUser USER1_60;
    public static final BasicUser USER2_60;
    public static final BasicUser USER_ADMIN_60;
    public static final BasicUser USER_SLASH_60;
    public static final String ROLE_ADMINISTRATORS = "Administrators";
    public static final boolean TESTING_JIRA_5_OR_NEWER;
    public static final boolean TESTING_JIRA_6_OR_NEWER;
    public static final int START_PROGRESS_TRANSITION_ID = 4;
    public static final int STOP_PROGRESS_TRANSITION_ID = 301;
    public static final String NUMERIC_CUSTOMFIELD_ID = "customfield_10000";
    public static final String NUMERIC_CUSTOMFIELD_TYPE = "com.atlassian.jira.plugin.system.customfieldtypes:float";
    public static final String NUMERIC_CUSTOMFIELD_TYPE_V5 = "number";
    private static final LocalTestEnvironmentData environmentData;
    private static final String URI_INTERFIX_FOR_USER;
    public static final String GROUP_JIRA_ADMINISTRATORS = "jira-administrators";
    public static final int CURRENT_BUILD_NUMBER;
    public static final ImmutableMap<String, String> AVATAR_SIZE_TO_NAME_MAP;

    public static URI buildUserAvatarUri(@Nullable String userName, Long avatarId, String size) {
        StringBuilder sb = new StringBuilder("secure/useravatar?");
        String sizeName = (String)AVATAR_SIZE_TO_NAME_MAP.get((Object)size);
        if (StringUtils.isNotBlank((String)sizeName)) {
            sb.append("size=").append(sizeName).append("&");
        }
        if (StringUtils.isNotBlank((String)userName)) {
            sb.append("ownerId=").append(userName).append("&");
        }
        sb.append("avatarId=").append(avatarId);
        return IntegrationTestUtil.resolveURI(sb.toString());
    }

    public static Map<String, URI> buildUserAvatarUris(@Nullable String user, Long avatarId) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (String size : AVATAR_SIZE_TO_NAME_MAP.keySet()) {
            builder.put((Object)size, (Object)IntegrationTestUtil.buildUserAvatarUri(user, avatarId, size));
        }
        return builder.build();
    }

    private static URI getUserUri(String username) throws URISyntaxException {
        return UriBuilder.fromUri((URI)environmentData.getBaseUrl().toURI()).path("/rest/api/" + URI_INTERFIX_FOR_USER + "/user").queryParam("username", new Object[]{username}).build(new Object[0]);
    }

    private static URI getLatestUserUri(String username) throws URISyntaxException {
        return UriBuilder.fromUri((URI)environmentData.getBaseUrl().toURI()).path("/rest/api/latest/user").queryParam("username", new Object[]{username}).build(new Object[0]);
    }

    public static URI concat(URI uri, String path) {
        return UriBuilder.fromUri((URI)uri).path(path).build(new Object[0]);
    }

    public static URI resolveURI(URI relativeUri) {
        try {
            return IntegrationTestUtil.concat(environmentData.getBaseUrl().toURI(), "/").resolve(relativeUri);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public static URI resolveURI(String relativeUri) {
        return IntegrationTestUtil.resolveURI(TestUtil.toUri(relativeUri));
    }

    static {
        environmentData = new LocalTestEnvironmentData();
        try {
            AsynchronousJiraRestClientFactory clientFactory = new AsynchronousJiraRestClientFactory();
            JiraRestClient client = clientFactory.create(environmentData.getBaseUrl().toURI(), (AuthenticationHandler)new BasicHttpAuthenticationHandler("admin", "admin"));
            CURRENT_BUILD_NUMBER = ((ServerInfo)client.getMetadataClient().getServerInfo().claim()).getBuildNumber();
            TESTING_JIRA_5_OR_NEWER = CURRENT_BUILD_NUMBER > 700;
            TESTING_JIRA_6_OR_NEWER = CURRENT_BUILD_NUMBER > 6000;
            URI_INTERFIX_FOR_USER = TESTING_JIRA_5_OR_NEWER ? "2" : "latest";
            AVATAR_SIZE_TO_NAME_MAP = CURRENT_BUILD_NUMBER >= 6060 ? ImmutableMap.builder().put((Object)"16x16", (Object)"xsmall").put((Object)"24x24", (Object)"small").put((Object)"32x32", (Object)"medium").put((Object)"48x48", (Object)"").build() : ImmutableMap.of((Object)"16x16", (Object)"small", (Object)"48x48", (Object)"");
            USER1_FULL = new User(IntegrationTestUtil.getUserUri("wseliga"), "wseliga", "Wojciech Seliga", "wojciech.seliga@spartez.com", null, IntegrationTestUtil.buildUserAvatarUris(null, 10082L), null);
            USER1 = new BasicUser(USER1_FULL.getSelf(), USER1_FULL.getName(), USER1_FULL.getDisplayName());
            USER1_LATEST = new BasicUser(IntegrationTestUtil.getLatestUserUri("wseliga"), "wseliga", "Wojciech Seliga");
            USER1_60 = TESTING_JIRA_6_OR_NEWER ? USER1 : USER1_LATEST;
            USER2 = new BasicUser(IntegrationTestUtil.getUserUri("user"), "user", "My Test User");
            USER2_LATEST = new BasicUser(IntegrationTestUtil.getLatestUserUri("user"), "user", "My Test User");
            USER2_60 = TESTING_JIRA_6_OR_NEWER ? USER2 : USER2_LATEST;
            USER_SLASH = new BasicUser(IntegrationTestUtil.getUserUri("a/user/with/slash"), "a/user/with/slash", "A User with / in its username");
            USER_SLASH_LATEST = new BasicUser(IntegrationTestUtil.getLatestUserUri("a/user/with/slash"), "a/user/with/slash", "A User with / in its username");
            USER_SLASH_60 = TESTING_JIRA_6_OR_NEWER ? USER_SLASH : USER_SLASH_LATEST;
            USER_ADMIN_FULL = new User(IntegrationTestUtil.getUserUri("admin"), "admin", "Administrator", "wojciech.seliga@spartez.com", null, IntegrationTestUtil.buildUserAvatarUris("admin", 10054L), null);
            USER_ADMIN = new BasicUser(USER_ADMIN_FULL.getSelf(), USER_ADMIN_FULL.getName(), USER_ADMIN_FULL.getDisplayName());
            USER_ADMIN_LATEST = new BasicUser(IntegrationTestUtil.getLatestUserUri("admin"), "admin", "Administrator");
            USER_ADMIN_60 = TESTING_JIRA_6_OR_NEWER ? USER_ADMIN : USER_ADMIN_LATEST;
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }
}

