/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.client.internal.async;

import com.atlassian.jira.rest.client.api.RestClientException;
import io.atlassian.util.concurrent.Promise;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import java.util.function.Function;

public class DelegatingPromise<T>
implements Promise<T> {
    private final Promise<T> delegate;

    public DelegatingPromise(Promise<T> delegate) {
        this.delegate = delegate;
    }

    public T claim() {
        try {
            return (T)this.delegate.claim();
        }
        catch (RestClientException e) {
            throw new RestClientException(e);
        }
    }

    public Promise<T> done(Consumer<? super T> e) {
        return this.delegate.done(e);
    }

    public Promise<T> fail(Consumer<Throwable> e) {
        return this.delegate.fail(e);
    }

    public Promise<T> then(Promise.TryConsumer<? super T> consumer) {
        return this.delegate.then(consumer);
    }

    public <B> Promise<B> map(Function<? super T, ? extends B> function) {
        return this.delegate.map(function);
    }

    public <B> Promise<B> flatMap(Function<? super T, ? extends Promise<? extends B>> function) {
        return this.delegate.flatMap(function);
    }

    public Promise<T> recover(Function<Throwable, ? extends T> handleThrowable) {
        return this.delegate.recover(handleThrowable);
    }

    public <B> Promise<B> fold(Function<Throwable, ? extends B> handleThrowable, Function<? super T, ? extends B> function) {
        return this.delegate.fold(handleThrowable, function);
    }

    public boolean cancel(boolean mayInterruptIfRunning) {
        return this.delegate.cancel(mayInterruptIfRunning);
    }

    public boolean isCancelled() {
        return this.delegate.isCancelled();
    }

    public boolean isDone() {
        return this.delegate.isDone();
    }

    public T get() throws InterruptedException, ExecutionException {
        return (T)this.delegate.get();
    }

    public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return (T)this.delegate.get(timeout, unit);
    }
}

