/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.client.internal.async;

import com.atlassian.httpclient.apache.httpcomponents.MultiPartEntityBuilder;
import com.atlassian.httpclient.api.EntityBuilder;
import com.atlassian.httpclient.api.HttpClient;
import com.atlassian.httpclient.api.Message;
import com.atlassian.httpclient.api.Response;
import com.atlassian.httpclient.api.ResponsePromise;
import com.atlassian.jira.rest.client.api.GetCreateIssueMetadataOptions;
import com.atlassian.jira.rest.client.api.IssueRestClient;
import com.atlassian.jira.rest.client.api.MetadataRestClient;
import com.atlassian.jira.rest.client.api.RestClientException;
import com.atlassian.jira.rest.client.api.SessionRestClient;
import com.atlassian.jira.rest.client.api.domain.BasicIssue;
import com.atlassian.jira.rest.client.api.domain.BulkOperationResult;
import com.atlassian.jira.rest.client.api.domain.CimProject;
import com.atlassian.jira.rest.client.api.domain.Comment;
import com.atlassian.jira.rest.client.api.domain.Issue;
import com.atlassian.jira.rest.client.api.domain.ServerInfo;
import com.atlassian.jira.rest.client.api.domain.Session;
import com.atlassian.jira.rest.client.api.domain.Transition;
import com.atlassian.jira.rest.client.api.domain.Votes;
import com.atlassian.jira.rest.client.api.domain.Watchers;
import com.atlassian.jira.rest.client.api.domain.input.AttachmentInput;
import com.atlassian.jira.rest.client.api.domain.input.IssueInput;
import com.atlassian.jira.rest.client.api.domain.input.LinkIssuesInput;
import com.atlassian.jira.rest.client.api.domain.input.TransitionInput;
import com.atlassian.jira.rest.client.api.domain.input.WorklogInput;
import com.atlassian.jira.rest.client.internal.async.AbstractAsynchronousRestClient;
import com.atlassian.jira.rest.client.internal.json.BasicIssueJsonParser;
import com.atlassian.jira.rest.client.internal.json.BasicIssuesJsonParser;
import com.atlassian.jira.rest.client.internal.json.CreateIssueMetadataJsonParser;
import com.atlassian.jira.rest.client.internal.json.IssueJsonParser;
import com.atlassian.jira.rest.client.internal.json.JsonObjectParser;
import com.atlassian.jira.rest.client.internal.json.JsonParseUtil;
import com.atlassian.jira.rest.client.internal.json.TransitionJsonParser;
import com.atlassian.jira.rest.client.internal.json.TransitionJsonParserV5;
import com.atlassian.jira.rest.client.internal.json.VotesJsonParser;
import com.atlassian.jira.rest.client.internal.json.WatchersJsonParserBuilder;
import com.atlassian.jira.rest.client.internal.json.gen.CommentJsonGenerator;
import com.atlassian.jira.rest.client.internal.json.gen.IssueInputJsonGenerator;
import com.atlassian.jira.rest.client.internal.json.gen.IssueUpdateJsonGenerator;
import com.atlassian.jira.rest.client.internal.json.gen.IssuesInputJsonGenerator;
import com.atlassian.jira.rest.client.internal.json.gen.LinkIssuesInputGenerator;
import com.atlassian.jira.rest.client.internal.json.gen.WorklogInputJsonGenerator;
import com.atlassian.util.concurrent.Promise;
import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import java.io.File;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import javax.ws.rs.core.UriBuilder;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

public class AsynchronousIssueRestClient
extends AbstractAsynchronousRestClient
implements IssueRestClient {
    private static final EnumSet<IssueRestClient.Expandos> DEFAULT_EXPANDS = EnumSet.of(IssueRestClient.Expandos.NAMES, IssueRestClient.Expandos.SCHEMA, IssueRestClient.Expandos.TRANSITIONS);
    private static final Function<IssueRestClient.Expandos, String> EXPANDO_TO_PARAM = from -> from.name().toLowerCase();
    private final SessionRestClient sessionRestClient;
    private final MetadataRestClient metadataRestClient;
    private final IssueJsonParser issueParser = new IssueJsonParser();
    private final BasicIssueJsonParser basicIssueParser = new BasicIssueJsonParser();
    private final JsonObjectParser<Watchers> watchersParser = WatchersJsonParserBuilder.createWatchersParser();
    private final TransitionJsonParser transitionJsonParser = new TransitionJsonParser();
    private final JsonObjectParser<Transition> transitionJsonParserV5 = new TransitionJsonParserV5();
    private final VotesJsonParser votesJsonParser = new VotesJsonParser();
    private final CreateIssueMetadataJsonParser createIssueMetadataJsonParser = new CreateIssueMetadataJsonParser();
    private static final String FILE_BODY_TYPE = "file";
    private final URI baseUri;
    private ServerInfo serverInfo;

    public AsynchronousIssueRestClient(URI baseUri, HttpClient client, SessionRestClient sessionRestClient, MetadataRestClient metadataRestClient) {
        super(client);
        this.baseUri = baseUri;
        this.sessionRestClient = sessionRestClient;
        this.metadataRestClient = metadataRestClient;
    }

    private synchronized ServerInfo getVersionInfo() {
        if (this.serverInfo == null) {
            this.serverInfo = (ServerInfo)this.metadataRestClient.getServerInfo().claim();
        }
        return this.serverInfo;
    }

    public Promise<BasicIssue> createIssue(IssueInput issue) {
        UriBuilder uriBuilder = UriBuilder.fromUri((URI)this.baseUri).path("issue");
        return this.postAndParse(uriBuilder.build(new Object[0]), issue, new IssueInputJsonGenerator(), this.basicIssueParser);
    }

    public Promise<Void> updateIssue(String issueKey, IssueInput issue) {
        UriBuilder uriBuilder = UriBuilder.fromUri((URI)this.baseUri).path("issue").path(issueKey);
        return this.put(uriBuilder.build(new Object[0]), issue, new IssueInputJsonGenerator());
    }

    public Promise<BulkOperationResult<BasicIssue>> createIssues(Collection<IssueInput> issues) {
        UriBuilder uriBuilder = UriBuilder.fromUri((URI)this.baseUri).path("issue/bulk");
        return this.postAndParse(uriBuilder.build(new Object[0]), issues, new IssuesInputJsonGenerator(), new BasicIssuesJsonParser());
    }

    public Promise<Iterable<CimProject>> getCreateIssueMetadata(@Nullable GetCreateIssueMetadataOptions options) {
        UriBuilder uriBuilder = UriBuilder.fromUri((URI)this.baseUri).path("issue/createmeta");
        if (options != null) {
            Iterable expandos;
            Iterable issueTypeNames;
            if (options.projectIds != null) {
                uriBuilder.queryParam("projectIds", new Object[]{Joiner.on((String)",").join(options.projectIds)});
            }
            if (options.projectKeys != null) {
                uriBuilder.queryParam("projectKeys", new Object[]{Joiner.on((String)",").join(options.projectKeys)});
            }
            if (options.issueTypeIds != null) {
                uriBuilder.queryParam("issuetypeIds", new Object[]{Joiner.on((String)",").join(options.issueTypeIds)});
            }
            if ((issueTypeNames = options.issueTypeNames) != null) {
                for (String name : issueTypeNames) {
                    uriBuilder.queryParam("issuetypeNames", new Object[]{name});
                }
            }
            if ((expandos = options.expandos) != null && expandos.iterator().hasNext()) {
                uriBuilder.queryParam("expand", new Object[]{Joiner.on((String)",").join(expandos)});
            }
        }
        return this.getAndParse(uriBuilder.build(new Object[0]), this.createIssueMetadataJsonParser);
    }

    public Promise<Issue> getIssue(String issueKey) {
        return this.getIssue(issueKey, Collections.emptyList());
    }

    public Promise<Issue> getIssue(String issueKey, Iterable<IssueRestClient.Expandos> expand) {
        UriBuilder uriBuilder = UriBuilder.fromUri((URI)this.baseUri);
        Iterable expands = Iterables.concat(DEFAULT_EXPANDS, expand);
        uriBuilder.path("issue").path(issueKey).queryParam("expand", new Object[]{StreamSupport.stream(expands.spliterator(), false).map(EXPANDO_TO_PARAM).collect(Collectors.joining(","))});
        return this.getAndParse(uriBuilder.build(new Object[0]), this.issueParser);
    }

    public Promise<Void> deleteIssue(String issueKey, boolean deleteSubtasks) {
        return this.delete(UriBuilder.fromUri((URI)this.baseUri).path("issue").path(issueKey).queryParam("deleteSubtasks", new Object[]{deleteSubtasks}).build(new Object[0]));
    }

    public Promise<Watchers> getWatchers(URI watchersUri) {
        return this.getAndParse(watchersUri, this.watchersParser);
    }

    public Promise<Votes> getVotes(URI votesUri) {
        return this.getAndParse(votesUri, this.votesJsonParser);
    }

    public Promise<Iterable<Transition>> getTransitions(URI transitionsUri) {
        return this.callAndParse(this.client().newRequest(transitionsUri).get(), (Response response) -> {
            JSONObject jsonObject = new JSONObject(response.getEntity());
            if (jsonObject.has("transitions")) {
                return JsonParseUtil.parseJsonArray(jsonObject.getJSONArray("transitions"), this.transitionJsonParserV5);
            }
            ArrayList<Transition> transitions = new ArrayList<Transition>(jsonObject.length());
            Iterator iterator = jsonObject.keys();
            while (iterator.hasNext()) {
                String key = (String)iterator.next();
                try {
                    int id = Integer.parseInt(key);
                    Transition transition = this.transitionJsonParser.parse(jsonObject.getJSONObject(key), id);
                    transitions.add(transition);
                }
                catch (JSONException e) {
                    throw new RestClientException((Throwable)e);
                }
                catch (NumberFormatException e) {
                    throw new RestClientException("Transition id should be an integer, but found [" + key + "]", (Throwable)e);
                }
            }
            return transitions;
        });
    }

    public Promise<Iterable<Transition>> getTransitions(Issue issue) {
        if (issue.getTransitionsUri() != null) {
            return this.getTransitions(issue.getTransitionsUri());
        }
        UriBuilder transitionsUri = UriBuilder.fromUri((URI)issue.getSelf());
        return this.getTransitions(transitionsUri.path("transitions").queryParam("expand", new Object[]{"transitions.fields"}).build(new Object[0]));
    }

    public Promise<Void> transition(URI transitionsUri, TransitionInput transitionInput) {
        int buildNumber = this.getVersionInfo().getBuildNumber();
        try {
            Iterable fields;
            JSONObject fieldsJs;
            JSONObject jsonObject = new JSONObject();
            if (buildNumber >= 700) {
                jsonObject.put("transition", (Object)new JSONObject().put("id", transitionInput.getId()));
            } else {
                jsonObject.put("transition", transitionInput.getId());
            }
            if (transitionInput.getComment() != null) {
                if (buildNumber >= 700) {
                    jsonObject.put("update", (Object)new JSONObject().put("comment", (Object)new JSONArray().put((Object)new JSONObject().put("add", (Object)new CommentJsonGenerator(this.getVersionInfo()).generate(transitionInput.getComment())))));
                } else {
                    jsonObject.put("comment", (Object)new CommentJsonGenerator(this.getVersionInfo()).generate(transitionInput.getComment()));
                }
            }
            if ((fieldsJs = new IssueUpdateJsonGenerator().generate(fields = transitionInput.getFields())).keys().hasNext()) {
                jsonObject.put("fields", (Object)fieldsJs);
            }
            if (fieldsJs.keys().hasNext()) {
                jsonObject.put("fields", (Object)fieldsJs);
            }
            return this.post(transitionsUri, jsonObject);
        }
        catch (JSONException ex) {
            throw new RestClientException((Throwable)ex);
        }
    }

    public Promise<Void> transition(Issue issue, TransitionInput transitionInput) {
        if (issue.getTransitionsUri() != null) {
            return this.transition(issue.getTransitionsUri(), transitionInput);
        }
        UriBuilder uriBuilder = UriBuilder.fromUri((URI)issue.getSelf());
        uriBuilder.path("transitions");
        return this.transition(uriBuilder.build(new Object[0]), transitionInput);
    }

    public Promise<Void> vote(URI votesUri) {
        return this.post(votesUri);
    }

    public Promise<Void> unvote(URI votesUri) {
        return this.delete(votesUri);
    }

    public Promise<Void> watch(URI watchersUri) {
        return this.post(watchersUri);
    }

    public Promise<Void> unwatch(URI watchersUri) {
        return this.removeWatcher(watchersUri, this.getLoggedUsername());
    }

    public Promise<Void> addWatcher(URI watchersUri, String username) {
        return this.post(watchersUri, JSONObject.quote((String)username));
    }

    public Promise<Void> removeWatcher(URI watchersUri, String username) {
        UriBuilder uriBuilder = UriBuilder.fromUri((URI)watchersUri);
        if (this.getVersionInfo().getBuildNumber() >= 640) {
            uriBuilder.queryParam("username", new Object[]{username});
        } else {
            uriBuilder.path(username).build(new Object[0]);
        }
        return this.delete(uriBuilder.build(new Object[0]));
    }

    public Promise<Void> linkIssue(LinkIssuesInput linkIssuesInput) {
        URI uri = UriBuilder.fromUri((URI)this.baseUri).path("issueLink").build(new Object[0]);
        return this.post(uri, linkIssuesInput, new LinkIssuesInputGenerator(this.getVersionInfo()));
    }

    public Promise<Void> addAttachment(URI attachmentsUri, InputStream inputStream, String filename) {
        MultipartEntityBuilder entityBuilder = MultipartEntityBuilder.create().setLaxMode().setCharset(StandardCharsets.UTF_8).addBinaryBody(FILE_BODY_TYPE, inputStream, ContentType.DEFAULT_BINARY, filename);
        return this.postAttachments(attachmentsUri, entityBuilder);
    }

    public Promise<Void> addAttachments(URI attachmentsUri, AttachmentInput ... attachments) {
        MultipartEntityBuilder entityBuilder = MultipartEntityBuilder.create().setLaxMode().setCharset(StandardCharsets.UTF_8);
        for (AttachmentInput attachmentInput : attachments) {
            entityBuilder.addBinaryBody(FILE_BODY_TYPE, attachmentInput.getInputStream(), ContentType.DEFAULT_BINARY, attachmentInput.getFilename());
        }
        return this.postAttachments(attachmentsUri, entityBuilder);
    }

    public Promise<Void> addAttachments(URI attachmentsUri, File ... files) {
        MultipartEntityBuilder entityBuilder = MultipartEntityBuilder.create().setLaxMode().setCharset(StandardCharsets.UTF_8);
        for (File file : files) {
            entityBuilder.addBinaryBody(FILE_BODY_TYPE, file);
        }
        return this.postAttachments(attachmentsUri, entityBuilder);
    }

    public Promise<Void> addComment(URI commentsUri, Comment comment) {
        return this.post(commentsUri, comment, new CommentJsonGenerator(this.getVersionInfo()));
    }

    public Promise<InputStream> getAttachment(URI attachmentUri) {
        return this.callAndParse(this.client().newRequest(attachmentUri).get(), Message::getEntityStream);
    }

    public Promise<Void> addWorklog(URI worklogUri, WorklogInput worklogInput) {
        UriBuilder uriBuilder = UriBuilder.fromUri((URI)worklogUri).queryParam("adjustEstimate", new Object[]{worklogInput.getAdjustEstimate().restValue});
        switch (worklogInput.getAdjustEstimate()) {
            case NEW: {
                uriBuilder.queryParam("newEstimate", new Object[]{Strings.nullToEmpty((String)worklogInput.getAdjustEstimateValue())});
                break;
            }
            case MANUAL: {
                uriBuilder.queryParam("reduceBy", new Object[]{Strings.nullToEmpty((String)worklogInput.getAdjustEstimateValue())});
            }
        }
        return this.post(uriBuilder.build(new Object[0]), worklogInput, new WorklogInputJsonGenerator());
    }

    private Promise<Void> postAttachments(URI attachmentsUri, MultipartEntityBuilder multipartEntityBuilder) {
        ResponsePromise responsePromise = this.client().newRequest(attachmentsUri).setEntity((EntityBuilder)new MultiPartEntityBuilder(multipartEntityBuilder.build())).setHeader("X-Atlassian-Token", "nocheck").post();
        return this.call(responsePromise);
    }

    private String getLoggedUsername() {
        return ((Session)this.sessionRestClient.getCurrentSession().claim()).getUsername();
    }
}

