/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.client.internal.async;

import com.atlassian.httpclient.api.HttpClient;
import com.atlassian.httpclient.api.Request;
import com.atlassian.httpclient.api.ResponsePromise;
import com.atlassian.httpclient.api.ResponseTransformation;
import com.atlassian.jira.rest.client.api.AuthenticationHandler;
import com.atlassian.jira.rest.client.internal.async.DisposableHttpClient;
import java.net.URI;
import java.util.regex.Pattern;

public abstract class AtlassianHttpClientDecorator
implements DisposableHttpClient {
    private final HttpClient httpClient;
    private final AuthenticationHandler authenticationHandler;

    public AtlassianHttpClientDecorator(HttpClient httpClient, AuthenticationHandler authenticationHandler) {
        this.httpClient = httpClient;
        this.authenticationHandler = authenticationHandler;
    }

    public void flushCacheByUriPattern(Pattern urlPattern) {
        this.httpClient.flushCacheByUriPattern(urlPattern);
    }

    public Request.Builder newRequest() {
        Request.Builder builder = this.httpClient.newRequest();
        this.configureAuthentication(builder);
        return builder;
    }

    public Request.Builder newRequest(URI uri) {
        Request.Builder builder = this.httpClient.newRequest(uri);
        this.configureAuthentication(builder);
        return builder;
    }

    public Request.Builder newRequest(URI uri, String contentType, String entity) {
        Request.Builder builder = this.httpClient.newRequest(uri, contentType, entity);
        this.configureAuthentication(builder);
        return builder;
    }

    public Request.Builder newRequest(String uri) {
        Request.Builder builder = this.httpClient.newRequest(uri);
        this.configureAuthentication(builder);
        return builder;
    }

    public Request.Builder newRequest(String uri, String contentType, String entity) {
        Request.Builder builder = this.httpClient.newRequest(uri, contentType, entity);
        this.configureAuthentication(builder);
        return builder;
    }

    private void configureAuthentication(Request.Builder builder) {
        if (this.authenticationHandler != null) {
            this.authenticationHandler.configure(builder);
        }
    }

    public <A> ResponseTransformation.Builder<A> transformation() {
        return this.httpClient.transformation();
    }

    public ResponsePromise execute(Request request) {
        return this.httpClient.execute(request);
    }
}

