/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.client.internal.async;

import com.atlassian.httpclient.api.HttpClient;
import com.atlassian.jira.rest.client.api.AuditRestClient;
import com.atlassian.jira.rest.client.api.domain.AuditRecordInput;
import com.atlassian.jira.rest.client.api.domain.AuditRecordsData;
import com.atlassian.jira.rest.client.api.domain.input.AuditRecordSearchInput;
import com.atlassian.jira.rest.client.internal.async.AbstractAsynchronousRestClient;
import com.atlassian.jira.rest.client.internal.json.AuditRecordsJsonParser;
import com.atlassian.jira.rest.client.internal.json.JsonParseUtil;
import com.atlassian.jira.rest.client.internal.json.gen.AuditRecordInputJsonGenerator;
import com.atlassian.util.concurrent.Promise;
import java.net.URI;
import javax.annotation.Nonnull;
import javax.ws.rs.core.UriBuilder;
import org.joda.time.ReadableInstant;

public class AsynchronousAuditRestClient
extends AbstractAsynchronousRestClient
implements AuditRestClient {
    private final URI baseUri;
    private final AuditRecordsJsonParser auditRecordsParser = new AuditRecordsJsonParser();

    protected AsynchronousAuditRestClient(HttpClient client, URI baseUri) {
        super(client);
        this.baseUri = baseUri;
    }

    public Promise<AuditRecordsData> getAuditRecords(AuditRecordSearchInput input) {
        return this.getAndParse(this.createSearchPathFromInput(input == null ? new AuditRecordSearchInput(null, null, null, null, null) : input), this.auditRecordsParser);
    }

    protected UriBuilder createPathBuilder() {
        UriBuilder uriBuilder = UriBuilder.fromUri((URI)this.baseUri);
        uriBuilder.path("auditing/record");
        return uriBuilder;
    }

    public void addAuditRecord(@Nonnull AuditRecordInput record) {
        this.post(this.createPathBuilder().build(new Object[0]), record, new AuditRecordInputJsonGenerator()).claim();
    }

    private URI createSearchPathFromInput(AuditRecordSearchInput input) {
        UriBuilder uriBuilder = this.createPathBuilder();
        if (input.getOffset() != null) {
            uriBuilder.queryParam("offset", new Object[]{input.getOffset()});
        }
        if (input.getLimit() != null) {
            uriBuilder.queryParam("limit", new Object[]{input.getLimit()});
        }
        if (input.getTextFilter() != null) {
            uriBuilder.queryParam("filter", new Object[]{input.getTextFilter()});
        }
        if (input.getFrom() != null) {
            String fromIsoString = JsonParseUtil.JIRA_DATE_TIME_FORMATTER.print((ReadableInstant)input.getFrom());
            uriBuilder.queryParam("from", new Object[]{fromIsoString});
        }
        if (input.getTo() != null) {
            String toIsoString = JsonParseUtil.JIRA_DATE_TIME_FORMATTER.print((ReadableInstant)input.getTo());
            uriBuilder.queryParam("to", new Object[]{toIsoString});
        }
        return uriBuilder.build(new Object[0]);
    }
}

