/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.client.internal.json.gen;

import com.atlassian.jira.rest.client.api.RestClientException;
import com.atlassian.jira.rest.client.api.domain.AssigneeType;
import com.atlassian.jira.rest.client.internal.domain.input.ComponentInputWithProjectKey;
import com.atlassian.jira.rest.client.internal.json.gen.JsonGenerator;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

public class ComponentInputWithProjectKeyJsonGenerator
implements JsonGenerator<ComponentInputWithProjectKey> {
    @Override
    public JSONObject generate(ComponentInputWithProjectKey componentInput) throws JSONException {
        AssigneeType assigneeType;
        JSONObject res = new JSONObject();
        if (componentInput.getProjectKey() != null) {
            res.put("project", (Object)componentInput.getProjectKey());
        }
        if (componentInput.getName() != null) {
            res.put("name", (Object)componentInput.getName());
        }
        if (componentInput.getDescription() != null) {
            res.put("description", (Object)componentInput.getDescription());
        }
        if (componentInput.getLeadUsername() != null) {
            res.put("leadUserName", (Object)componentInput.getLeadUsername());
        }
        if ((assigneeType = componentInput.getAssigneeType()) != null) {
            String assigneeTypeStr;
            switch (assigneeType) {
                case PROJECT_DEFAULT: {
                    assigneeTypeStr = "PROJECT_DEFAULT";
                    break;
                }
                case COMPONENT_LEAD: {
                    assigneeTypeStr = "COMPONENT_LEAD";
                    break;
                }
                case PROJECT_LEAD: {
                    assigneeTypeStr = "PROJECT_LEAD";
                    break;
                }
                case UNASSIGNED: {
                    assigneeTypeStr = "UNASSIGNED";
                    break;
                }
                default: {
                    throw new RestClientException("Unexpected assignee type [" + assigneeType + "]", null);
                }
            }
            res.put("assigneeType", (Object)assigneeTypeStr);
        }
        return res;
    }
}

