/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.client.internal.async;

import com.atlassian.httpclient.api.EntityBuilder;
import com.atlassian.httpclient.api.HttpClient;
import com.atlassian.httpclient.api.Response;
import com.atlassian.httpclient.api.ResponsePromise;
import com.atlassian.jira.rest.client.api.RestClientException;
import com.atlassian.jira.rest.client.api.domain.util.ErrorCollection;
import com.atlassian.jira.rest.client.internal.json.JsonArrayParser;
import com.atlassian.jira.rest.client.internal.json.JsonObjectParser;
import com.atlassian.jira.rest.client.internal.json.JsonParseUtil;
import com.atlassian.jira.rest.client.internal.json.JsonParser;
import com.atlassian.jira.rest.client.internal.json.gen.JsonGenerator;
import com.atlassian.util.concurrent.Promise;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import javax.annotation.Nullable;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

public abstract class AbstractAsynchronousRestClient {
    private static final String JSON_CONTENT_TYPE = "application/json";
    private final HttpClient client;

    protected AbstractAsynchronousRestClient(HttpClient client) {
        this.client = client;
    }

    protected final <T> Promise<T> getAndParse(URI uri, JsonParser<?, T> parser) {
        return this.callAndParse(this.client.newRequest(uri).get(), parser);
    }

    protected final <I, T> Promise<T> postAndParse(URI uri, I entity, JsonGenerator<I> jsonGenerator, JsonObjectParser<T> parser) {
        ResponsePromise responsePromise = this.client.newRequest(uri).setEntity(this.toEntity(jsonGenerator, entity)).post();
        return this.callAndParse(responsePromise, parser);
    }

    protected final <T> Promise<T> postAndParse(URI uri, JSONObject entity, JsonObjectParser<T> parser) {
        ResponsePromise responsePromise = this.client.newRequest(uri).setEntity(entity.toString()).setContentType(JSON_CONTENT_TYPE).post();
        return this.callAndParse(responsePromise, parser);
    }

    protected final Promise<Void> post(URI uri, String entity) {
        ResponsePromise responsePromise = this.client.newRequest(uri).setEntity(entity).setContentType(JSON_CONTENT_TYPE).post();
        return this.call(responsePromise);
    }

    protected final Promise<Void> post(URI uri, JSONObject entity) {
        return this.post(uri, entity.toString());
    }

    protected final <T> Promise<Void> post(URI uri, T entity, JsonGenerator<T> jsonGenerator) {
        ResponsePromise responsePromise = this.client.newRequest(uri).setEntity(this.toEntity(jsonGenerator, entity)).post();
        return this.call(responsePromise);
    }

    protected final Promise<Void> post(URI uri) {
        return this.post(uri, "");
    }

    protected final <I, T> Promise<T> putAndParse(URI uri, I entity, JsonGenerator<I> jsonGenerator, JsonObjectParser<T> parser) {
        ResponsePromise responsePromise = this.client.newRequest(uri).setEntity(this.toEntity(jsonGenerator, entity)).put();
        return this.callAndParse(responsePromise, parser);
    }

    protected final Promise<Void> delete(URI uri) {
        ResponsePromise responsePromise = this.client.newRequest(uri).delete();
        return this.call(responsePromise);
    }

    /*
     * Exception decompiling
     */
    protected final <T> Promise<T> callAndParse(ResponsePromise responsePromise, ResponseHandler<T> responseHandler) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.bytecode.analysis.types.BindingSuperContainer.getBoundAssignable(org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance, org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance)" because "maybeBindingContainer" is null
         *     at org.benf.cfr.reader.bytecode.analysis.types.GenericTypeBinder.extractBaseBindings(GenericTypeBinder.java:125)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteFunctionInvokation(ExplicitTypeCallRewriter.java:37)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:56)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:71)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.AbstractExpressionRewriter.rewriteExpression(AbstractExpressionRewriter.java:14)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:75)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractConstructorInvokation.applyExpressionRewriter(AbstractConstructorInvokation.java:65)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.AbstractExpressionRewriter.rewriteExpression(AbstractExpressionRewriter.java:14)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:75)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.ReturnValueStatement.rewriteExpressions(ReturnValueStatement.java:62)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.rewrite(Op03SimpleStatement.java:479)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.Op03Rewriters.rewriteWith(Op03Rewriters.java:23)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:819)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected final <T> Promise<T> callAndParse(ResponsePromise responsePromise, final JsonParser<?, T> parser) {
        ResponseHandler responseHandler = new ResponseHandler<T>(){

            @Override
            public T handle(Response response) throws JSONException, IOException {
                String body = response.getEntity();
                return parser instanceof JsonObjectParser ? ((JsonObjectParser)parser).parse(new JSONObject(body)) : ((JsonArrayParser)parser).parse(new JSONArray(body));
            }
        };
        return this.callAndParse(responsePromise, responseHandler);
    }

    /*
     * Exception decompiling
     */
    protected final Promise<Void> call(ResponsePromise responsePromise) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.bytecode.analysis.types.BindingSuperContainer.getBoundAssignable(org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance, org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance)" because "maybeBindingContainer" is null
         *     at org.benf.cfr.reader.bytecode.analysis.types.GenericTypeBinder.extractBaseBindings(GenericTypeBinder.java:125)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteFunctionInvokation(ExplicitTypeCallRewriter.java:37)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:56)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:71)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.AbstractExpressionRewriter.rewriteExpression(AbstractExpressionRewriter.java:14)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:75)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractConstructorInvokation.applyExpressionRewriter(AbstractConstructorInvokation.java:65)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.AbstractExpressionRewriter.rewriteExpression(AbstractExpressionRewriter.java:14)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:75)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.ReturnValueStatement.rewriteExpressions(ReturnValueStatement.java:62)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.rewrite(Op03SimpleStatement.java:479)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.Op03Rewriters.rewriteWith(Op03Rewriters.java:23)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:819)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected HttpClient client() {
        return this.client;
    }

    private static <T> Function<Response, T> errorFunction() {
        return new Function<Response, T>(){

            public T apply(Response response) {
                try {
                    String body = response.getEntity();
                    Collection<ErrorCollection> errorMessages = AbstractAsynchronousRestClient.extractErrors(response.getStatusCode(), body);
                    throw new RestClientException(errorMessages, response.getStatusCode());
                }
                catch (JSONException e) {
                    throw new RestClientException((Throwable)e, response.getStatusCode());
                }
            }
        };
    }

    private static <T> Function<Response, ? extends T> toFunction(final ResponseHandler<T> responseHandler) {
        return new Function<Response, T>(){

            public T apply(@Nullable Response input) {
                try {
                    return responseHandler.handle(input);
                }
                catch (JSONException e) {
                    throw new RestClientException((Throwable)e);
                }
                catch (IOException e) {
                    throw new RestClientException((Throwable)e);
                }
            }
        };
    }

    private static <T> Function<Response, T> constant(final T value) {
        return new Function<Response, T>(){

            public T apply(Response input) {
                return value;
            }
        };
    }

    static Collection<ErrorCollection> extractErrors(int status, String body) throws JSONException {
        if (body == null) {
            return Collections.emptyList();
        }
        JSONObject jsonObject = new JSONObject(body);
        JSONArray issues = jsonObject.optJSONArray("issues");
        ImmutableList.Builder results = ImmutableList.builder();
        if (issues != null && issues.length() == 0) {
            JSONArray errors = jsonObject.optJSONArray("errors");
            for (int i = 0; i < errors.length(); ++i) {
                JSONObject currentJsonObject = errors.getJSONObject(i);
                results.add((Object)AbstractAsynchronousRestClient.getErrorsFromJson(currentJsonObject.getInt("status"), currentJsonObject.optJSONObject("elementErrors")));
            }
        } else {
            results.add((Object)AbstractAsynchronousRestClient.getErrorsFromJson(status, jsonObject));
        }
        return results.build();
    }

    private static ErrorCollection getErrorsFromJson(int status, JSONObject jsonObject) throws JSONException {
        JSONObject jsonErrors = jsonObject.optJSONObject("errors");
        JSONArray jsonErrorMessages = jsonObject.optJSONArray("errorMessages");
        Collection<Object> errorMessages = jsonErrorMessages != null ? JsonParseUtil.toStringCollection(jsonErrorMessages) : Collections.emptyList();
        Map<Object, Object> errors = jsonErrors != null && jsonErrors.length() > 0 ? JsonParseUtil.toStringMap(jsonErrors.names(), jsonErrors) : Collections.emptyMap();
        return new ErrorCollection(Integer.valueOf(status), errorMessages, errors);
    }

    private <T> EntityBuilder toEntity(final JsonGenerator<T> generator, final T bean) {
        return new EntityBuilder(){

            public EntityBuilder.Entity build() {
                return new EntityBuilder.Entity(){

                    public Map<String, String> getHeaders() {
                        return Collections.singletonMap("Content-Type", AbstractAsynchronousRestClient.JSON_CONTENT_TYPE);
                    }

                    public InputStream getInputStream() {
                        try {
                            return new ByteArrayInputStream(generator.generate(bean).toString().getBytes(Charset.forName("UTF-8")));
                        }
                        catch (JSONException e) {
                            throw new RestClientException((Throwable)e);
                        }
                    }
                };
            }
        };
    }

    protected static interface ResponseHandler<T> {
        public T handle(Response var1) throws JSONException, IOException;
    }
}

