/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.client.api;

import com.atlassian.jira.rest.client.api.GetCreateIssueMetadataOptions;
import com.atlassian.jira.rest.client.api.domain.BasicIssue;
import com.atlassian.jira.rest.client.api.domain.BulkOperationResult;
import com.atlassian.jira.rest.client.api.domain.CimFieldInfo;
import com.atlassian.jira.rest.client.api.domain.CimProject;
import com.atlassian.jira.rest.client.api.domain.Comment;
import com.atlassian.jira.rest.client.api.domain.Issue;
import com.atlassian.jira.rest.client.api.domain.IssueType;
import com.atlassian.jira.rest.client.api.domain.Page;
import com.atlassian.jira.rest.client.api.domain.Transition;
import com.atlassian.jira.rest.client.api.domain.Votes;
import com.atlassian.jira.rest.client.api.domain.Watchers;
import com.atlassian.jira.rest.client.api.domain.input.AttachmentInput;
import com.atlassian.jira.rest.client.api.domain.input.IssueInput;
import com.atlassian.jira.rest.client.api.domain.input.LinkIssuesInput;
import com.atlassian.jira.rest.client.api.domain.input.TransitionInput;
import com.atlassian.jira.rest.client.api.domain.input.WorklogInput;
import com.google.common.annotations.Beta;
import io.atlassian.util.concurrent.Promise;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.File;
import java.io.InputStream;
import java.net.URI;
import java.util.Collection;

public interface IssueRestClient {
    public Promise<BasicIssue> createIssue(IssueInput var1);

    public Promise<Void> updateIssue(String var1, IssueInput var2);

    public Promise<Iterable<CimProject>> getCreateIssueMetadata(@Nullable GetCreateIssueMetadataOptions var1);

    public Promise<BulkOperationResult<BasicIssue>> createIssues(Collection<IssueInput> var1);

    public Promise<Page<IssueType>> getCreateIssueMetaProjectIssueTypes(@Nonnull String var1, @Nullable Long var2, @Nullable Integer var3);

    public Promise<Page<CimFieldInfo>> getCreateIssueMetaFields(@Nonnull String var1, @Nonnull String var2, @Nullable Long var3, @Nullable Integer var4);

    public Promise<Issue> getIssue(String var1);

    public Promise<Issue> getIssue(String var1, Iterable<Expandos> var2);

    public Promise<Void> deleteIssue(String var1, boolean var2);

    public Promise<Watchers> getWatchers(URI var1);

    public Promise<Votes> getVotes(URI var1);

    public Promise<Iterable<Transition>> getTransitions(URI var1);

    public Promise<Iterable<Transition>> getTransitions(Issue var1);

    public Promise<Void> transition(URI var1, TransitionInput var2);

    public Promise<Void> transition(Issue var1, TransitionInput var2);

    public Promise<Void> vote(URI var1);

    public Promise<Void> unvote(URI var1);

    public Promise<Void> watch(URI var1);

    public Promise<Void> unwatch(URI var1);

    public Promise<Void> addWatcher(URI var1, String var2);

    public Promise<Void> removeWatcher(URI var1, String var2);

    public Promise<Void> linkIssue(LinkIssuesInput var1);

    public Promise<Void> addAttachment(URI var1, InputStream var2, String var3);

    public Promise<Void> addAttachments(URI var1, AttachmentInput ... var2);

    public Promise<Void> addAttachments(URI var1, File ... var2);

    public Promise<Void> addComment(URI var1, Comment var2);

    @Beta
    public Promise<InputStream> getAttachment(URI var1);

    public Promise<Void> addWorklog(URI var1, WorklogInput var2);

    public static enum Expandos {
        CHANGELOG("changelog"),
        OPERATIONS("operations"),
        SCHEMA("schema"),
        NAMES("names"),
        TRANSITIONS("transitions");

        private final String value;

        private Expandos(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }
}

