/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.client.api.domain;

import com.atlassian.jira.rest.client.api.domain.BasicProject;
import com.atlassian.jira.rest.client.api.domain.CimIssueType;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import java.net.URI;
import java.util.Map;

public class CimProject
extends BasicProject {
    private final Map<String, URI> avatarUris;
    private final Iterable<CimIssueType> issueTypes;

    public CimProject(URI self, String key, Long id, String name, Map<String, URI> avatarUris, Iterable<CimIssueType> issueTypes) {
        super(self, key, id, name);
        this.avatarUris = avatarUris;
        this.issueTypes = issueTypes;
    }

    public Iterable<CimIssueType> getIssueTypes() {
        return this.issueTypes;
    }

    public Map<String, URI> getAvatarUris() {
        return this.avatarUris;
    }

    @Override
    protected MoreObjects.ToStringHelper getToStringHelper() {
        return super.getToStringHelper().add("issueTypes", this.issueTypes).add("avatarUris", this.avatarUris);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{super.hashCode(), this.avatarUris, this.issueTypes});
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof CimProject) {
            CimProject that = (CimProject)obj;
            return super.equals(obj) && Objects.equal(this.avatarUris, that.avatarUris) && Objects.equal(this.issueTypes, that.issueTypes);
        }
        return false;
    }
}

