/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.client.api.domain;

import com.atlassian.jira.rest.client.api.AddressableEntity;
import com.atlassian.jira.rest.client.api.domain.BasicUser;
import com.google.common.base.Objects;
import java.net.URI;
import javax.annotation.Nullable;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;

public class Attachment
implements AddressableEntity {
    private final URI self;
    private final String filename;
    private final BasicUser author;
    private final DateTime creationDate;
    private final int size;
    private final String mimeType;
    private final URI contentUri;
    @Nullable
    private final URI thumbnailUri;

    public Attachment(URI self, String filename, BasicUser author, DateTime creationDate, int size, String mimeType, URI contentUri, URI thumbnailUri) {
        this.self = self;
        this.filename = filename;
        this.author = author;
        this.creationDate = creationDate;
        this.size = size;
        this.mimeType = mimeType;
        this.contentUri = contentUri;
        this.thumbnailUri = thumbnailUri;
    }

    public boolean hasThumbnail() {
        return this.thumbnailUri != null;
    }

    @Override
    public URI getSelf() {
        return this.self;
    }

    public String getFilename() {
        return this.filename;
    }

    public BasicUser getAuthor() {
        return this.author;
    }

    public DateTime getCreationDate() {
        return this.creationDate;
    }

    public int getSize() {
        return this.size;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public URI getContentUri() {
        return this.contentUri;
    }

    @Nullable
    public URI getThumbnailUri() {
        return this.thumbnailUri;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("self", (Object)this.self).add("filename", (Object)this.filename).add("author", (Object)this.author).add("creationDate", (Object)this.creationDate).add("size", this.size).add("mimeType", (Object)this.mimeType).add("contentUri", (Object)this.contentUri).add("thumbnailUri", (Object)this.thumbnailUri).toString();
    }

    public boolean equals(Object obj) {
        if (obj instanceof Attachment) {
            Attachment that = (Attachment)obj;
            return Objects.equal((Object)this.self, (Object)that.self) && Objects.equal((Object)this.filename, (Object)that.filename) && Objects.equal((Object)this.author, (Object)that.author) && this.creationDate.isEqual((ReadableInstant)that.creationDate) && Objects.equal((Object)this.size, (Object)that.size) && Objects.equal((Object)this.mimeType, (Object)that.mimeType) && Objects.equal((Object)this.contentUri, (Object)that.contentUri) && Objects.equal((Object)this.thumbnailUri, (Object)that.thumbnailUri);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.self, this.filename, this.author, this.creationDate, this.size, this.mimeType, this.contentUri, this.thumbnailUri});
    }
}

