/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.client.api.domain;

import com.atlassian.jira.rest.client.api.ExpandableResource;
import com.atlassian.jira.rest.client.api.domain.Attachment;
import com.atlassian.jira.rest.client.api.domain.BasicComponent;
import com.atlassian.jira.rest.client.api.domain.BasicIssue;
import com.atlassian.jira.rest.client.api.domain.BasicIssueType;
import com.atlassian.jira.rest.client.api.domain.BasicPriority;
import com.atlassian.jira.rest.client.api.domain.BasicProject;
import com.atlassian.jira.rest.client.api.domain.BasicResolution;
import com.atlassian.jira.rest.client.api.domain.BasicStatus;
import com.atlassian.jira.rest.client.api.domain.BasicVotes;
import com.atlassian.jira.rest.client.api.domain.BasicWatchers;
import com.atlassian.jira.rest.client.api.domain.ChangelogGroup;
import com.atlassian.jira.rest.client.api.domain.Comment;
import com.atlassian.jira.rest.client.api.domain.IssueField;
import com.atlassian.jira.rest.client.api.domain.IssueLink;
import com.atlassian.jira.rest.client.api.domain.Subtask;
import com.atlassian.jira.rest.client.api.domain.TimeTracking;
import com.atlassian.jira.rest.client.api.domain.User;
import com.atlassian.jira.rest.client.api.domain.Version;
import com.atlassian.jira.rest.client.api.domain.Worklog;
import com.google.common.base.Objects;
import java.net.URI;
import java.util.Collection;
import java.util.Set;
import javax.annotation.Nullable;
import javax.ws.rs.core.UriBuilder;
import org.joda.time.DateTime;

public class Issue
extends BasicIssue
implements ExpandableResource {
    private final BasicStatus status;
    private final BasicIssueType issueType;
    private final BasicProject project;
    private final URI transitionsUri;
    private final Iterable<String> expandos;
    private final Collection<BasicComponent> components;
    private final String summary;
    @Nullable
    private final String description;
    @Nullable
    private final User reporter;
    private final User assignee;
    @Nullable
    private final BasicResolution resolution;
    private final Collection<IssueField> issueFields;
    private final DateTime creationDate;
    private final DateTime updateDate;
    private final DateTime dueDate;
    private final BasicPriority priority;
    private final BasicVotes votes;
    @Nullable
    private final Collection<Version> fixVersions;
    @Nullable
    private final Collection<Version> affectedVersions;
    private final Collection<Comment> comments;
    @Nullable
    private final Collection<IssueLink> issueLinks;
    private final Collection<Attachment> attachments;
    private final Collection<Worklog> worklogs;
    private final BasicWatchers watchers;
    @Nullable
    private final TimeTracking timeTracking;
    @Nullable
    private final Collection<Subtask> subtasks;
    @Nullable
    private final Collection<ChangelogGroup> changelog;
    private final Set<String> labels;

    public Issue(String summary, URI self, String key, Long id, BasicProject project, BasicIssueType issueType, BasicStatus status, String description, @Nullable BasicPriority priority, @Nullable BasicResolution resolution, Collection<Attachment> attachments, @Nullable User reporter, @Nullable User assignee, DateTime creationDate, DateTime updateDate, DateTime dueDate, Collection<Version> affectedVersions, Collection<Version> fixVersions, Collection<BasicComponent> components, @Nullable TimeTracking timeTracking, Collection<IssueField> issueFields, Collection<Comment> comments, @Nullable URI transitionsUri, @Nullable Collection<IssueLink> issueLinks, BasicVotes votes, Collection<Worklog> worklogs, BasicWatchers watchers, Iterable<String> expandos, @Nullable Collection<Subtask> subtasks, @Nullable Collection<ChangelogGroup> changelog, Set<String> labels) {
        super(self, key, id);
        this.summary = summary;
        this.project = project;
        this.status = status;
        this.description = description;
        this.resolution = resolution;
        this.expandos = expandos;
        this.comments = comments;
        this.attachments = attachments;
        this.issueFields = issueFields;
        this.issueType = issueType;
        this.reporter = reporter;
        this.assignee = assignee;
        this.creationDate = creationDate;
        this.updateDate = updateDate;
        this.dueDate = dueDate;
        this.transitionsUri = transitionsUri;
        this.issueLinks = issueLinks;
        this.votes = votes;
        this.worklogs = worklogs;
        this.watchers = watchers;
        this.fixVersions = fixVersions;
        this.affectedVersions = affectedVersions;
        this.components = components;
        this.priority = priority;
        this.timeTracking = timeTracking;
        this.subtasks = subtasks;
        this.changelog = changelog;
        this.labels = labels;
    }

    public BasicStatus getStatus() {
        return this.status;
    }

    @Nullable
    public User getReporter() {
        return this.reporter;
    }

    @Nullable
    public User getAssignee() {
        return this.assignee;
    }

    public String getSummary() {
        return this.summary;
    }

    @Nullable
    public BasicPriority getPriority() {
        return this.priority;
    }

    @Nullable
    public Iterable<IssueLink> getIssueLinks() {
        return this.issueLinks;
    }

    @Nullable
    public Iterable<Subtask> getSubtasks() {
        return this.subtasks;
    }

    public Iterable<IssueField> getFields() {
        return this.issueFields;
    }

    @Nullable
    public IssueField getField(String id) {
        for (IssueField issueField : this.issueFields) {
            if (!issueField.getId().equals(id)) continue;
            return issueField;
        }
        return null;
    }

    @Nullable
    public IssueField getFieldByName(String name) {
        for (IssueField issueField : this.issueFields) {
            if (!issueField.getName().equals(name)) continue;
            return issueField;
        }
        return null;
    }

    @Override
    public Iterable<String> getExpandos() {
        return this.expandos;
    }

    public BasicIssueType getIssueType() {
        return this.issueType;
    }

    public Iterable<Attachment> getAttachments() {
        return this.attachments;
    }

    public URI getAttachmentsUri() {
        return UriBuilder.fromUri((URI)this.getSelf()).path("attachments").build(new Object[0]);
    }

    public URI getWorklogUri() {
        return UriBuilder.fromUri((URI)this.getSelf()).path("worklog").build(new Object[0]);
    }

    public Iterable<Comment> getComments() {
        return this.comments;
    }

    public URI getCommentsUri() {
        return UriBuilder.fromUri((URI)this.getSelf()).path("comment").build(new Object[0]);
    }

    public BasicProject getProject() {
        return this.project;
    }

    @Nullable
    public BasicVotes getVotes() {
        return this.votes;
    }

    public Iterable<Worklog> getWorklogs() {
        return this.worklogs;
    }

    @Nullable
    public BasicWatchers getWatchers() {
        return this.watchers;
    }

    @Nullable
    public Iterable<Version> getFixVersions() {
        return this.fixVersions;
    }

    @Nullable
    public URI getTransitionsUri() {
        return this.transitionsUri;
    }

    @Nullable
    public Iterable<Version> getAffectedVersions() {
        return this.affectedVersions;
    }

    public Iterable<BasicComponent> getComponents() {
        return this.components;
    }

    public Set<String> getLabels() {
        return this.labels;
    }

    @Nullable
    public Iterable<ChangelogGroup> getChangelog() {
        return this.changelog;
    }

    public URI getVotesUri() {
        return UriBuilder.fromUri((URI)this.getSelf()).path("votes").build(new Object[0]);
    }

    @Nullable
    public BasicResolution getResolution() {
        return this.resolution;
    }

    public DateTime getCreationDate() {
        return this.creationDate;
    }

    public DateTime getUpdateDate() {
        return this.updateDate;
    }

    public DateTime getDueDate() {
        return this.dueDate;
    }

    @Nullable
    public TimeTracking getTimeTracking() {
        return this.timeTracking;
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    @Override
    protected Objects.ToStringHelper getToStringHelper() {
        return super.getToStringHelper().add("project", (Object)this.project).add("status", (Object)this.status).add("description", (Object)this.description).add("expandos", this.expandos).add("resolution", (Object)this.resolution).add("reporter", (Object)this.reporter).add("assignee", (Object)this.assignee).addValue((Object)"\n").add("fields", this.issueFields).addValue((Object)"\n").add("affectedVersions", this.affectedVersions).addValue((Object)"\n").add("fixVersions", this.fixVersions).addValue((Object)"\n").add("components", this.components).addValue((Object)"\n").add("issueType", (Object)this.issueType).add("creationDate", (Object)this.creationDate).add("updateDate", (Object)this.updateDate).addValue((Object)"\n").add("dueDate", (Object)this.dueDate).addValue((Object)"\n").add("attachments", this.attachments).addValue((Object)"\n").add("comments", this.comments).addValue((Object)"\n").add("transitionsUri", (Object)this.transitionsUri).add("issueLinks", this.issueLinks).addValue((Object)"\n").add("votes", (Object)this.votes).addValue((Object)"\n").add("worklogs", this.worklogs).addValue((Object)"\n").add("watchers", (Object)this.watchers).add("timeTracking", (Object)this.timeTracking).add("changelog", this.changelog).add("labels", this.labels);
    }
}

