/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.api.util;

import com.atlassian.jira.util.ErrorCollection;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.ws.rs.core.Response;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

@XmlRootElement
public class ErrorCollection
implements Serializable {
    @XmlElement
    private Collection<String> errorMessages = Lists.newArrayList();
    @XmlElement
    private Map<String, String> errors = Maps.newHashMap();
    private Integer status = null;

    @Nonnull
    public static ErrorCollection of(String ... messages) {
        return ErrorCollection.of(Arrays.asList(messages));
    }

    @Nonnull
    public static ErrorCollection of(@Nonnull Collection<String> messages) {
        return new ErrorCollection().addErrorMessages(messages);
    }

    @Nonnull
    public static ErrorCollection of(@Nonnull com.atlassian.jira.util.ErrorCollection errorCollection) {
        return new ErrorCollection().addErrorCollection(errorCollection);
    }

    @Nonnull
    public ErrorCollection addErrorCollection(@Nonnull com.atlassian.jira.util.ErrorCollection errorCollection) {
        this.errorMessages.addAll(Objects.requireNonNull(errorCollection).getErrorMessages());
        this.errors.putAll(errorCollection.getErrors());
        this.reason(ErrorCollection.Reason.getWorstReason((Collection)errorCollection.getReasons()));
        return this;
    }

    @Nonnull
    public ErrorCollection addErrorCollection(@Nonnull ErrorCollection errorCollection) {
        this.errorMessages.addAll(Objects.requireNonNull(errorCollection).getErrorMessages());
        this.errors.putAll(errorCollection.getErrors());
        return this;
    }

    @Nonnull
    public ErrorCollection addErrorMessage(@Nonnull String errorMessage) {
        this.errorMessages.add(Objects.requireNonNull(errorMessage));
        return this;
    }

    @Nonnull
    public ErrorCollection addErrorMessages(@Nonnull Collection<String> messages) {
        this.errorMessages.addAll(Objects.requireNonNull(messages));
        return this;
    }

    public boolean hasAnyErrors() {
        return !this.errorMessages.isEmpty() || !this.errors.isEmpty();
    }

    @Nonnull
    public Collection<String> getErrorMessages() {
        return this.errorMessages;
    }

    @Nonnull
    public Map<String, String> getErrors() {
        return this.errors;
    }

    @Nonnull
    public ErrorCollection reason(@Nullable ErrorCollection.Reason reason) {
        this.status = reason == null ? Response.Status.BAD_REQUEST.getStatusCode() : reason.getHttpStatusCode();
        return this;
    }

    @Nullable
    public Integer getStatus() {
        return this.status;
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this, (String[])new String[0]);
    }

    public boolean equals(Object o) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)o, (String[])new String[0]);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }
}

