/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.api.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement
public class WarningCollection
implements Serializable {
    @XmlElement
    private Collection<String> warningMessages = new ArrayList<String>();

    @Nonnull
    public static WarningCollection of(String ... messages) {
        return WarningCollection.of(Arrays.asList(messages));
    }

    @Nonnull
    public static WarningCollection of(@Nonnull Collection<String> messages) {
        return new WarningCollection().addWarningMessages(messages);
    }

    @Nonnull
    public static WarningCollection of(@Nonnull com.atlassian.jira.util.WarningCollection warningCollection) {
        return new WarningCollection().addWarningCollection(warningCollection);
    }

    private WarningCollection() {
    }

    @Nonnull
    public WarningCollection addWarningCollection(@Nonnull com.atlassian.jira.util.WarningCollection warningCollection) {
        this.warningMessages.addAll(Objects.requireNonNull(warningCollection).getWarnings());
        return this;
    }

    @Nonnull
    public WarningCollection addWarningCollection(@Nonnull WarningCollection warningCollection) {
        this.warningMessages.addAll(Objects.requireNonNull(warningCollection).getWarningMessages());
        return this;
    }

    @Nonnull
    public WarningCollection addWarningMessage(@Nonnull String warningMessage) {
        this.warningMessages.add(Objects.requireNonNull(warningMessage));
        return this;
    }

    @Nonnull
    public WarningCollection addWarningMessages(@Nonnull Collection<String> messages) {
        this.warningMessages.addAll(Objects.requireNonNull(messages));
        return this;
    }

    @Nonnull
    public Collection<String> getWarningMessages() {
        return this.warningMessages;
    }

    public boolean hasAnyWarnings() {
        return !this.warningMessages.isEmpty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WarningCollection that = (WarningCollection)o;
        return Objects.equals(this.warningMessages, that.warningMessages);
    }

    public int hashCode() {
        return Objects.hash(this.warningMessages);
    }

    public String toString() {
        return "WarningCollection{warningMessages=" + this.warningMessages + '}';
    }
}

