/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.api.util;

import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.dbc.Assertions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import javax.ws.rs.core.Response;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

@XmlRootElement
public class ErrorCollection {
    @XmlElement
    private Collection<String> errorMessages = Lists.newArrayList();
    @XmlElement
    private Map<String, String> errors = Maps.newHashMap();
    private Integer status = null;

    public static ErrorCollection of(String ... messages) {
        return ErrorCollection.of(Arrays.asList(messages));
    }

    public static ErrorCollection of(Collection<String> messages) {
        return new ErrorCollection().addErrorMessages(messages);
    }

    public static ErrorCollection of(com.atlassian.jira.util.ErrorCollection errorCollection) {
        return new ErrorCollection().addErrorCollection(errorCollection);
    }

    public ErrorCollection addErrorCollection(com.atlassian.jira.util.ErrorCollection errorCollection) {
        this.errorMessages.addAll(((com.atlassian.jira.util.ErrorCollection)Assertions.notNull((Object)errorCollection)).getErrorMessages());
        this.errors.putAll(errorCollection.getErrors());
        this.reason(ErrorCollection.Reason.getWorstReason((Collection)errorCollection.getReasons()));
        return this;
    }

    public ErrorCollection addErrorMessage(String errorMessage) {
        this.errorMessages.add((String)Assertions.notNull((Object)errorMessage));
        return this;
    }

    public ErrorCollection addErrorMessages(Collection<String> messages) {
        this.errorMessages.addAll((Collection)Assertions.notNull(messages));
        return this;
    }

    public boolean hasAnyErrors() {
        return !this.errorMessages.isEmpty() || !this.errors.isEmpty();
    }

    public Collection<String> getErrorMessages() {
        return this.errorMessages;
    }

    public Map<String, String> getErrors() {
        return this.errors;
    }

    public ErrorCollection reason(ErrorCollection.Reason reason) {
        this.status = reason == null ? Response.Status.BAD_REQUEST.getStatusCode() : reason.getHttpStatusCode();
        return this;
    }

    public Integer getStatus() {
        return this.status;
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this, (String[])new String[0]);
    }

    public boolean equals(Object o) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)o, (String[])new String[0]);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }
}

