/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.api.permission;

import com.atlassian.jira.rest.api.permission.PermissionGrantBean;
import com.atlassian.jira.rest.api.permission.PermissionSchemeExpandParam;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.codehaus.jackson.annotate.JsonProperty;

public final class PermissionSchemeBean {
    @JsonProperty
    private String expand = PermissionSchemeExpandParam.PERMISSION_SCHEME_EXPAND_PARAMS;
    @JsonProperty
    private Long id;
    @JsonProperty
    private URI self;
    @JsonProperty
    private String name;
    @JsonProperty
    private String description;
    @JsonProperty
    private List<PermissionGrantBean> permissions;

    @Deprecated
    public PermissionSchemeBean() {
    }

    private PermissionSchemeBean(Long id, URI self, String name, String description, Iterable<PermissionGrantBean> permissions) {
        this.id = id;
        this.self = self;
        this.name = name;
        this.description = description;
        this.permissions = permissions != null ? ImmutableList.copyOf(permissions) : null;
    }

    public PermissionSchemeBean input() {
        this.expand = null;
        return this;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public URI getSelf() {
        return this.self;
    }

    public void setSelf(URI self) {
        this.self = self;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public List<PermissionGrantBean> getPermissions() {
        return this.permissions;
    }

    public void setPermissions(ArrayList<PermissionGrantBean> permissions) {
        this.permissions = permissions;
    }

    public String getExpand() {
        return this.expand;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PermissionSchemeBean that = (PermissionSchemeBean)o;
        return Objects.equal((Object)this.id, (Object)that.id) && Objects.equal((Object)this.self, (Object)that.self) && Objects.equal((Object)this.name, (Object)that.name) && Objects.equal((Object)this.description, (Object)that.description) && Objects.equal(this.permissions, that.permissions);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.id, this.self, this.name, this.description, this.permissions});
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private Long id;
        private URI self;
        private String name;
        private String description;
        private Iterable<PermissionGrantBean> permissions;

        private Builder() {
        }

        public Builder setId(Long id) {
            this.id = id;
            return this;
        }

        public Builder setSelf(URI self) {
            this.self = self;
            return this;
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Builder setDescription(String description) {
            this.description = description;
            return this;
        }

        public Builder setPermissions(Iterable<PermissionGrantBean> permissions) {
            this.permissions = permissions;
            return this;
        }

        public PermissionSchemeBean build() {
            return new PermissionSchemeBean(this.id, this.self, this.name, this.description, this.permissions);
        }
    }
}

