package com.atlassian.jira.rest.api.issue;

import com.google.common.collect.Maps;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.codehaus.jackson.annotate.JsonProperty;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Issue update/create request.
 *
 * @since v5.0
 */
@JsonIgnoreProperties (ignoreUnknown = true)
public class IssueUpdateRequest
{
    @JsonProperty
    protected Map<String, List<FieldOperation>> update = Maps.newHashMap();
    @JsonProperty
    protected IssueFields fields;

    public IssueFields fields()
    {
        return this.fields;
    }

    public IssueUpdateRequest fields(IssueFields fields)
    {
        this.fields = fields;
        return this;
    }

    public  Map<String, List<FieldOperation>> update()
    {
        return update;
    }

    public IssueUpdateRequest update(Map<String, List<FieldOperation>> update)
    {
      this.update = update;
      return this;
    }

    /**
     * Sets the update operations for a single field.
     *
     * @param field a String containing the field name
     * @param updates a List of FieldOperation
     * @return this
     */
    public IssueUpdateRequest update(String field, List<FieldOperation> updates)
    {
        this.update.put(field, updates);
        return this;
    }

    @Override
    public String toString()
    {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.SHORT_PREFIX_STYLE);
    }

    static final IssueUpdateRequest DOC_EXAMPLE;
    static
    {
        IssueUpdateRequest issueUpdateRequest = new IssueUpdateRequest();
        issueUpdateRequest.update = new HashMap<String, List<FieldOperation>>();
        List<FieldOperation> summaryOperations = new ArrayList<FieldOperation>();
        FieldOperation summaryOperation = new FieldOperation();
        summaryOperation.init("set", "Bug in business logic");
        summaryOperations.add(summaryOperation);
        issueUpdateRequest.update.put("summary", summaryOperations);

        List<FieldOperation> componentsOperations = new ArrayList<FieldOperation>();
        FieldOperation componentsOperation = new FieldOperation();
        componentsOperation.init("clear", "");
        componentsOperations.add(componentsOperation);
        issueUpdateRequest.update.put("components", componentsOperations);

        List<FieldOperation> labelOperations = new ArrayList<FieldOperation>();
        FieldOperation labelOperation1 = new FieldOperation();
        labelOperation1.init("add", "triaged");
        labelOperations.add(labelOperation1);

        FieldOperation labelOperation2 = new FieldOperation();
        labelOperation2.init("remove", "blocker");
        labelOperations.add(labelOperation2);

        issueUpdateRequest.update.put("labels", labelOperations);

        DOC_EXAMPLE = issueUpdateRequest;
    }

}
