/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.api.util;

import com.atlassian.jira.security.xsrf.XsrfCheckResult;
import com.atlassian.jira.security.xsrf.XsrfInvocationChecker;
import java.io.IOException;
import java.io.InputStream;
import javax.annotation.Nullable;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;

public class AttachmentHelper {
    private static final String DEFAULT_CONTENT_TYPE = "application/octet-stream";
    private final XsrfInvocationChecker xsrfChecker;

    public AttachmentHelper(XsrfInvocationChecker xsrfChecker) {
        this.xsrfChecker = xsrfChecker;
    }

    public ValidationResult validate(HttpServletRequest request, String filename, @Nullable Long size) {
        ServletInputStream inputStream;
        XsrfCheckResult xsrfCheckResult = this.xsrfChecker.checkWebRequestInvocation(request);
        if (xsrfCheckResult.isRequired() && !xsrfCheckResult.isValid()) {
            return new ValidationResult(ValidationError.XSRF_TOKEN_INVALID, null);
        }
        if (StringUtils.isBlank((String)filename)) {
            return new ValidationResult(ValidationError.FILENAME_BLANK, null);
        }
        if ((size == null || size < 0L) && (size = Long.valueOf(request.getContentLength())) < 0L) {
            return new ValidationResult(ValidationError.ATTACHMENT_IO_SIZE, null);
        }
        try {
            inputStream = request.getInputStream();
        }
        catch (IOException e) {
            return new ValidationResult(ValidationError.ATTACHMENT_IO_UNKNOWN, null);
        }
        String contentType = request.getContentType();
        if (StringUtils.isBlank((String)contentType)) {
            contentType = DEFAULT_CONTENT_TYPE;
        }
        return new ValidationResult((InputStream)inputStream, size, contentType);
    }

    public static class ValidationResult {
        private final long size;
        private final InputStream inputStream;
        private final String contentType;
        private final ValidationError errorType;
        private final String errorMessage;

        public ValidationResult(InputStream inputStream, long size, String contentType) {
            this.inputStream = inputStream;
            this.size = size;
            this.contentType = contentType;
            this.errorType = null;
            this.errorMessage = null;
        }

        public ValidationResult(ValidationError errorType, String errorMessage) {
            this.inputStream = null;
            this.size = -1L;
            this.contentType = null;
            this.errorType = errorType;
            this.errorMessage = errorMessage;
        }

        public long getSize() {
            return this.size;
        }

        public InputStream getInputStream() {
            return this.inputStream;
        }

        public String getContentType() {
            return this.contentType;
        }

        public ValidationError getErrorType() {
            return this.errorType;
        }

        public boolean isValid() {
            return this.errorType == null;
        }

        public String getErrorMessage() {
            return this.errorMessage;
        }
    }

    public static enum ValidationError {
        ATTACHMENT_IO_SIZE,
        ATTACHMENT_IO_UNKNOWN,
        FILENAME_BLANK,
        XSRF_TOKEN_INVALID;

    }
}

