/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.api.util;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.apache.commons.lang.StringUtils;

@Immutable
public class StringList {
    private static final String QUERY_PARAM_SEPARATOR = ",";
    private final ImmutableList<String> list;

    public static StringList fromList(String ... strings) {
        return new StringList(Arrays.asList(strings));
    }

    public static StringList fromList(Iterable<String> strings) {
        return new StringList(strings);
    }

    public static StringList fromQueryParam(String queryParam) {
        return new StringList(queryParam);
    }

    public StringList() {
        this(Collections.emptyList());
    }

    public StringList(@Nullable String queryParam) {
        this(queryParam != null ? Arrays.asList(StringUtils.split((String)queryParam, (String)QUERY_PARAM_SEPARATOR)) : null);
    }

    public StringList(@Nullable Iterable<String> fields) {
        this.list = fields != null ? ImmutableList.copyOf(fields) : ImmutableList.of();
    }

    public ImmutableList<String> asList() {
        return this.list;
    }

    public String toQueryParam() {
        return StringUtils.join(this.list, (String)QUERY_PARAM_SEPARATOR);
    }

    public StringList extend(StringList stringList) {
        return new StringList(Iterables.concat(this.list, stringList.list));
    }

    public static StringList joinLists(List<StringList> stringLists) {
        StringList result = new StringList();
        for (StringList stringList : stringLists) {
            result = result.extend(stringList);
        }
        return result;
    }

    public String toString() {
        return "StringList" + this.list.toString();
    }
}

