/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.api.permission;

import com.atlassian.jira.permission.JiraPermissionHolderType;
import com.atlassian.jira.permission.PermissionHolderType;
import com.google.common.base.MoreObjects;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import java.util.Optional;

public final class PermissionHolderTypeMapping {
    private static final BiMap<String, PermissionHolderType> holderTypesMap = ImmutableBiMap.builder().put((Object)"group", (Object)JiraPermissionHolderType.GROUP).put((Object)"anyone", (Object)JiraPermissionHolderType.ANYONE).put((Object)"user", (Object)JiraPermissionHolderType.USER).put((Object)"projectRole", (Object)JiraPermissionHolderType.PROJECT_ROLE).put((Object)"reporter", (Object)JiraPermissionHolderType.REPORTER).put((Object)"projectLead", (Object)JiraPermissionHolderType.PROJECT_LEAD).put((Object)"assignee", (Object)JiraPermissionHolderType.ASSIGNEE).put((Object)"userCustomField", (Object)JiraPermissionHolderType.USER_CUSTOM_FIELD).put((Object)"groupCustomField", (Object)JiraPermissionHolderType.GROUP_CUSTOM_FIELD).put((Object)"reporterWithCreatePermission", (Object)JiraPermissionHolderType.REPORTER_WITH_CREATE_PERMISSION).put((Object)"assigneeWithAssignablePermission", (Object)JiraPermissionHolderType.ASSIGNEE_WITH_ASSIGNABLE_PERMISSION).build();

    private PermissionHolderTypeMapping() {
    }

    public static String toRestType(PermissionHolderType holderType) {
        return (String)MoreObjects.firstNonNull((Object)((String)holderTypesMap.inverse().get((Object)holderType)), (Object)holderType.getKey());
    }

    public static Optional<PermissionHolderType> fromRestType(String holderType) {
        return Optional.ofNullable((PermissionHolderType)holderTypesMap.get((Object)holderType));
    }
}

