/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.api.issue;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

@JsonIgnoreProperties(ignoreUnknown=true)
public class RemoteIssueLinkCreateOrUpdateRequest {
    @JsonProperty
    @Schema(example="system=http://www.mycompany.com/support&id=1")
    private String globalId;
    @JsonProperty
    private Application application = new Application();
    @JsonProperty
    @Schema(example="causes")
    private String relationship;
    @JsonProperty
    private RemoteObject object = new RemoteObject();

    public String globalId() {
        return this.globalId;
    }

    public RemoteIssueLinkCreateOrUpdateRequest globalId(String globalId) {
        this.globalId = globalId;
        return this;
    }

    public String applicationType() {
        return this.application.type;
    }

    public RemoteIssueLinkCreateOrUpdateRequest applicationType(String applicationType) {
        this.application.type = applicationType;
        return this;
    }

    public String applicationName() {
        return this.application.name;
    }

    public RemoteIssueLinkCreateOrUpdateRequest applicationName(String applicationName) {
        this.application.name = applicationName;
        return this;
    }

    public String relationship() {
        return this.relationship;
    }

    public RemoteIssueLinkCreateOrUpdateRequest relationship(String relationship) {
        this.relationship = relationship;
        return this;
    }

    public String url() {
        return this.object.url;
    }

    public RemoteIssueLinkCreateOrUpdateRequest url(String url) {
        this.object.url = url;
        return this;
    }

    public String title() {
        return this.object.title;
    }

    public RemoteIssueLinkCreateOrUpdateRequest title(String title) {
        this.object.title = title;
        return this;
    }

    public String summary() {
        return this.object.summary;
    }

    public RemoteIssueLinkCreateOrUpdateRequest summary(String summary) {
        this.object.summary = summary;
        return this;
    }

    public String iconUrl() {
        return this.object.icon.url16x16;
    }

    public RemoteIssueLinkCreateOrUpdateRequest iconUrl(String iconUrl) {
        this.object.icon.url16x16 = iconUrl;
        return this;
    }

    public String iconTitle() {
        return this.object.icon.title;
    }

    public RemoteIssueLinkCreateOrUpdateRequest iconTitle(String iconTitle) {
        this.object.icon.title = iconTitle;
        return this;
    }

    public Boolean resolved() {
        return this.object.status.resolved;
    }

    public RemoteIssueLinkCreateOrUpdateRequest resolved(Boolean resolved) {
        this.object.status.resolved = resolved;
        return this;
    }

    public String statusIconUrl() {
        return this.object.status.icon.url16x16;
    }

    public RemoteIssueLinkCreateOrUpdateRequest statusIconUrl(String statusIconUrl) {
        this.object.status.icon.url16x16 = statusIconUrl;
        return this;
    }

    public String statusIconTitle() {
        return this.object.status.icon.title;
    }

    public RemoteIssueLinkCreateOrUpdateRequest statusIconTitle(String statusIconTitle) {
        this.object.status.icon.title = statusIconTitle;
        return this;
    }

    public String statusIconLink() {
        return this.object.status.icon.link;
    }

    public RemoteIssueLinkCreateOrUpdateRequest statusIconLink(String statusIconLink) {
        this.object.status.icon.link = statusIconLink;
        return this;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    private static class Application {
        @JsonProperty
        @Schema(example="com.acme.tracker")
        private String type;
        @JsonProperty
        @Schema(example="My Acme Tracker")
        private String name;

        private Application() {
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    private static class RemoteObject {
        @JsonProperty
        @Schema(example="http://www.mycompany.com/support?id=1")
        private String url;
        @JsonProperty
        @Schema(example="TSTSUP-111")
        private String title;
        @JsonProperty
        @Schema(example="Crazy customer support issue")
        private String summary;
        @JsonProperty
        private Icon icon = new Icon();
        @JsonProperty
        private Status status = new Status();

        private RemoteObject() {
        }

        @JsonIgnoreProperties(ignoreUnknown=true)
        private static class Icon {
            @JsonProperty
            @Schema(example="http://www.mycompany.com/support/ticket.png")
            private String url16x16;
            @JsonProperty
            @Schema(example="Support Ticket")
            private String title;
            @JsonProperty
            @Schema(example="http://www.mycompany.com/support/resolved.png")
            private String link;

            private Icon() {
            }
        }

        @JsonIgnoreProperties(ignoreUnknown=true)
        private static class Status {
            @JsonProperty
            @Schema(example="true")
            private Boolean resolved;
            @JsonProperty
            @Schema(example="http://www.mycompany.com/support/resolved.png")
            private Icon icon = new Icon();

            private Status() {
            }
        }
    }
}

