/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.api.field;

import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.Field;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.SearchableField;
import com.atlassian.jira.issue.fields.rest.RestAwareField;
import com.atlassian.jira.issue.fields.rest.json.JsonType;
import com.atlassian.jira.issue.fields.rest.json.JsonTypeBuilder;
import com.atlassian.jira.issue.search.ClauseNames;
import com.atlassian.jira.issue.search.managers.SearchHandlerManager;
import com.atlassian.jira.rest.api.issue.JsonTypeBean;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

@XmlRootElement(name="field")
public class FieldBean {
    public static final FieldBean DOC_EXAMPLE;
    public static final FieldBean DOC_EXAMPLE_2;
    public static final FieldBean DOC_EXAMPLE_CF;
    @XmlElement
    @Schema(example="description")
    private String id;
    @XmlElement
    @Schema(example="Description")
    private String name;
    @XmlElement
    @Schema(example="false")
    private Boolean custom;
    @XmlElement
    @Schema(example="true")
    private Boolean orderable;
    @XmlElement
    @Schema(example="true")
    private Boolean navigable;
    @XmlElement
    @Schema(example="true")
    private Boolean searchable;
    @XmlElement
    @Schema(example="[description]")
    private Set<String> clauseNames;
    @XmlElement
    private JsonTypeBean schema;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Boolean getCustom() {
        return this.custom;
    }

    public void setCustom(Boolean custom) {
        this.custom = custom;
    }

    public Boolean getOrderable() {
        return this.orderable;
    }

    public void setOrderable(Boolean orderable) {
        this.orderable = orderable;
    }

    public Boolean getNavigable() {
        return this.navigable;
    }

    public void setNavigable(Boolean navigable) {
        this.navigable = navigable;
    }

    public Boolean getSearchable() {
        return this.searchable;
    }

    public void setSearchable(Boolean searchable) {
        this.searchable = searchable;
    }

    public JsonTypeBean getSchema() {
        return this.schema;
    }

    public void setSchema(JsonTypeBean schema) {
        this.schema = schema;
    }

    public Set<String> getClauseNames() {
        return this.clauseNames;
    }

    public void setClauseNames(Set<String> clauseNames) {
        this.clauseNames = clauseNames;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }

    public static Collection<FieldBean> shortBeans(Collection<Field> fields, final FieldManager fieldManager, final SearchHandlerManager searchHandlerManager) {
        if (fields == null) {
            return null;
        }
        return ImmutableList.copyOf((Iterable)Iterables.transform(fields, (Function)new Function<Field, FieldBean>(){

            public FieldBean apply(Field from) {
                return FieldBean.shortBean(from, fieldManager, searchHandlerManager);
            }
        }));
    }

    public static FieldBean shortBean(Field field, FieldManager fieldManager, SearchHandlerManager searchHandlerManager) {
        if (field == null) {
            return null;
        }
        FieldBean bean = new FieldBean();
        bean.id = field.getId();
        bean.name = field.getName();
        bean.custom = field instanceof CustomField;
        bean.orderable = fieldManager.isOrderableField(field);
        bean.navigable = fieldManager.isNavigableField(field);
        bean.searchable = field instanceof SearchableField;
        Collection jqlClauseNames = searchHandlerManager.getJqlClauseNames(field.getId());
        bean.clauseNames = new LinkedHashSet<String>();
        for (ClauseNames names : jqlClauseNames) {
            bean.clauseNames.addAll(names.getJqlFieldNames());
        }
        if (field instanceof RestAwareField) {
            JsonType type = ((RestAwareField)field).getJsonSchema();
            bean.schema = new JsonTypeBean(type);
        } else {
            bean.schema = null;
        }
        return bean;
    }

    static {
        JsonType schema = JsonTypeBuilder.system((String)"string", (String)"description");
        LinkedHashSet<String> clauseNames = new LinkedHashSet<String>();
        clauseNames.add("description");
        DOC_EXAMPLE = new FieldBean();
        FieldBean.DOC_EXAMPLE.id = "description";
        FieldBean.DOC_EXAMPLE.name = "Description";
        FieldBean.DOC_EXAMPLE.custom = false;
        FieldBean.DOC_EXAMPLE.orderable = true;
        FieldBean.DOC_EXAMPLE.navigable = true;
        FieldBean.DOC_EXAMPLE.searchable = true;
        FieldBean.DOC_EXAMPLE.clauseNames = clauseNames;
        FieldBean.DOC_EXAMPLE.schema = new JsonTypeBean(schema);
        schema = JsonTypeBuilder.system((String)"string", (String)"summary");
        clauseNames = new LinkedHashSet();
        clauseNames.add("summary");
        DOC_EXAMPLE_2 = new FieldBean();
        FieldBean.DOC_EXAMPLE_2.id = "summary";
        FieldBean.DOC_EXAMPLE_2.name = "Summary";
        FieldBean.DOC_EXAMPLE_2.custom = false;
        FieldBean.DOC_EXAMPLE_2.orderable = true;
        FieldBean.DOC_EXAMPLE_2.navigable = true;
        FieldBean.DOC_EXAMPLE_2.searchable = true;
        FieldBean.DOC_EXAMPLE_2.clauseNames = clauseNames;
        FieldBean.DOC_EXAMPLE_2.schema = new JsonTypeBean(schema);
        schema = JsonTypeBuilder.custom((String)"project", (String)"com.atlassian.jira.plugin.system.customfieldtypes:project", (Long)10101L);
        clauseNames = new LinkedHashSet();
        clauseNames.add("cf[10101]");
        clauseNames.add("New custom field");
        DOC_EXAMPLE_CF = new FieldBean();
        FieldBean.DOC_EXAMPLE_CF.id = "customfield_10101";
        FieldBean.DOC_EXAMPLE_CF.name = "New custom field";
        FieldBean.DOC_EXAMPLE_CF.custom = true;
        FieldBean.DOC_EXAMPLE_CF.orderable = true;
        FieldBean.DOC_EXAMPLE_CF.navigable = true;
        FieldBean.DOC_EXAMPLE_CF.searchable = true;
        FieldBean.DOC_EXAMPLE_CF.clauseNames = clauseNames;
        FieldBean.DOC_EXAMPLE_CF.schema = new JsonTypeBean(schema);
    }
}

