/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.api.expand;

import com.atlassian.plugins.rest.api.expand.listwrapper.ListWrapper;
import com.atlassian.plugins.rest.api.expand.listwrapper.ListWrapperCallback;
import com.atlassian.plugins.rest.api.expand.parameter.Indexes;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;

@XmlRootElement(name="list")
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class SimpleListWrapper<T>
implements ListWrapper<T> {
    @XmlAttribute(name="size")
    private int size;
    @XmlAttribute(name="max-results")
    private Integer maxResults;
    @XmlElement(name="items")
    private List<T> items = Collections.emptyList();
    @XmlTransient
    private ListWrapperCallback<T> pagingCallback;

    public static <T> SimpleListWrapper<T> empty() {
        return SimpleListWrapper.of(Collections.emptyList());
    }

    public static <T> SimpleListWrapper<T> of(T ... elements) {
        return SimpleListWrapper.of(Arrays.asList(elements));
    }

    public static <T> SimpleListWrapper<T> of(List<T> list) {
        return SimpleListWrapper.of(list, null);
    }

    public static <T> SimpleListWrapper<T> of(List<T> list, Integer maxResults) {
        return new SimpleListWrapper<T>(list, maxResults, list.size());
    }

    public static <T> SimpleListWrapper<T> of(List<T> list, Integer maxResults, int size) {
        return new SimpleListWrapper<T>(list, maxResults, size);
    }

    private SimpleListWrapper() {
    }

    protected SimpleListWrapper(List<T> list, Integer maxResults, int size) {
        this.size = size;
        this.maxResults = maxResults;
        this.pagingCallback = SimpleListWrapper.ofList(ImmutableList.copyOf(list), maxResults != null ? maxResults : Integer.MAX_VALUE);
    }

    @XmlTransient
    public ListWrapperCallback<T> getPagingCallback() {
        return this.pagingCallback;
    }

    public int getSize() {
        return this.size;
    }

    public Integer getMaxResults() {
        return this.maxResults;
    }

    @XmlTransient
    public final ListWrapperCallback<T> getCallback() {
        return new ListWrapperCallback<T>(){

            public List<T> getItems(Indexes indexes) {
                return SimpleListWrapper.this.getPagingCallback().getItems(indexes);
            }
        };
    }

    public String toString() {
        return "SimpleListWrapper{size=" + this.size + ", maxResults=" + this.maxResults + ", pagingCallback=" + this.pagingCallback + ", items=" + this.items + "}";
    }

    static <T> ListWrapperCallback<T> ofList(final List<T> items, final int maxResults) {
        if (items == null) {
            throw new NullPointerException("items");
        }
        if (maxResults < 0) {
            throw new IllegalArgumentException("maxResults must be non-negative: " + maxResults);
        }
        return new ListWrapperCallback<T>(){

            public List<T> getItems(Indexes indexes) {
                if (maxResults == 0) {
                    return Collections.emptyList();
                }
                int remainingResults = maxResults;
                ArrayList toReturn = Lists.newArrayListWithCapacity((int)Math.min(items.size(), maxResults));
                for (Integer i : indexes.getIndexes(items.size())) {
                    if (remainingResults-- == 0) break;
                    toReturn.add(items.get(i));
                }
                return toReturn;
            }
        };
    }
}

