/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.api.expand;

import com.atlassian.plugins.rest.api.expand.annotation.Expandable;
import com.atlassian.plugins.rest.api.expand.listwrapper.ListWrapper;
import com.atlassian.plugins.rest.api.expand.listwrapper.ListWrapperCallback;
import com.atlassian.plugins.rest.api.expand.parameter.Indexes;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.google.common.collect.Lists;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlTransient;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public abstract class PagedListWrapper<T, Z>
implements ListWrapper<T> {
    @XmlAttribute
    @Schema(example="50")
    protected int size;
    @XmlAttribute(name="max-results")
    @Schema(example="50")
    private final int maxResults;
    @XmlAttribute(name="start-index")
    @Schema(example="0")
    protected int startIndex;
    @XmlAttribute(name="end-index")
    @Schema(example="50")
    protected int endIndex;
    @XmlElement(name="items")
    @Expandable
    @Schema(example="[]")
    private final Collection<T> items = Lists.newArrayList();

    protected PagedListWrapper() {
        this.size = 0;
        this.maxResults = 0;
        this.startIndex = 0;
        this.endIndex = 0;
    }

    private PagedListWrapper(int maxResults, int startIndex, int endIndex, Collection<T> items) {
        this.maxResults = maxResults;
        this.startIndex = startIndex;
        this.endIndex = endIndex;
        this.items.addAll(items);
        this.size = this.items.size();
    }

    public PagedListWrapper(int size, int maxResults) {
        this.size = size;
        this.maxResults = maxResults;
    }

    public int getSize() {
        return this.size;
    }

    public Collection<T> getItems() {
        return this.items;
    }

    public int getMaxResults() {
        return this.maxResults;
    }

    @XmlTransient
    public final ListWrapperCallback<T> getCallback() {
        return new ListWrapperCallback<T>(){

            public List<T> getItems(Indexes indexes) {
                return PagedListWrapper.this.getPagingCallback().getItems(indexes);
            }
        };
    }

    @XmlTransient
    public ListWrapperCallback<T> getPagingCallback() {
        return new ListWrapperCallback<T>(){
            final List<T> pagedBeans = Lists.newArrayList();

            public List<T> getItems(Indexes indexes) {
                PagedListWrapper.this.size = PagedListWrapper.this.getBackingListSize();
                if (PagedListWrapper.this.size > 0) {
                    PagedListWrapper.this.startIndex = indexes.getMinIndex(PagedListWrapper.this.getSize());
                    if (PagedListWrapper.this.startIndex >= 0) {
                        PagedListWrapper.this.endIndex = this.calculateEndIndex(indexes);
                        List sortedBackingObjects = PagedListWrapper.this.getOrderedList(PagedListWrapper.this.startIndex, PagedListWrapper.this.endIndex);
                        for (Object backingObject : sortedBackingObjects) {
                            this.pagedBeans.add(PagedListWrapper.this.fromBackedObject(backingObject));
                        }
                    }
                }
                return this.pagedBeans;
            }

            private int calculateEndIndex(Indexes indexes) {
                int maxResultsSize;
                int maxIndex = indexes.getMaxIndex(PagedListWrapper.this.getSize());
                int resultsSize = maxIndex - PagedListWrapper.this.startIndex + 1;
                if (resultsSize > (maxResultsSize = PagedListWrapper.this.getMaxResults())) {
                    int maxAllowedEndIdex = PagedListWrapper.this.startIndex + maxResultsSize - 1;
                    return Math.min(maxAllowedEndIdex, PagedListWrapper.this.getSize() - 1);
                }
                return maxIndex;
            }
        };
    }

    public abstract T fromBackedObject(Z var1);

    @XmlTransient
    public abstract int getBackingListSize();

    @XmlTransient
    public abstract List<Z> getOrderedList(int var1, int var2);

    public static class PagedListWrapperDocExample<T, Z>
    extends PagedListWrapper<T, Z> {
        public PagedListWrapperDocExample(int maxResults, int startIndex, int endIndex, Collection<T> items) {
            super(maxResults, startIndex, endIndex, items);
        }

        @Override
        public T fromBackedObject(Z backedObject) {
            throw new UnsupportedOperationException("This class is for documentation purpose only, do not use it.");
        }

        @Override
        public int getBackingListSize() {
            throw new UnsupportedOperationException("This class is for documentation purpose only, do not use it.");
        }

        @Override
        public List<Z> getOrderedList(int startIndex, int endIndex) {
            throw new UnsupportedOperationException("This class is for documentation purpose only, do not use it.");
        }
    }
}

