/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.api.dashboard;

import com.atlassian.jira.rest.api.dashboard.DashboardBean;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.List;

public class DashboardsBean {
    @JsonProperty
    @Schema(example="10")
    private Integer startAt;
    @JsonProperty
    @Schema(example="10")
    private Integer maxResults;
    @JsonProperty
    @Schema(example="143")
    private Integer total;
    @JsonProperty
    @Schema(example="http://localhost:8090/jira/rest/api/2.0/dashboard?startAt=0")
    private String prev;
    @JsonProperty
    @Schema(example="http://localhost:8090/jira/rest/api/2.0/dashboard?startAt=10")
    private String next;
    @JsonProperty
    private List<DashboardBean> dashboards;

    public DashboardsBean() {
    }

    public DashboardsBean(Integer startAt, Integer maxResults, Integer total, String prev, String next, List<DashboardBean> dashboards) {
        this.startAt = startAt;
        this.maxResults = maxResults;
        this.total = total;
        this.prev = prev;
        this.next = next;
        this.dashboards = dashboards != null ? ImmutableList.copyOf(dashboards) : null;
    }

    public Integer startAt() {
        return this.startAt;
    }

    public DashboardsBean startAt(Integer startAt) {
        return new DashboardsBean(startAt, this.maxResults, this.total, this.prev, this.next, this.dashboards);
    }

    public Integer maxResults() {
        return this.maxResults;
    }

    public DashboardsBean maxResults(Integer maxResults) {
        return new DashboardsBean(this.startAt, maxResults, this.total, this.prev, this.next, this.dashboards);
    }

    public Integer total() {
        return this.total;
    }

    public DashboardsBean total(Integer total) {
        return new DashboardsBean(this.startAt, this.maxResults, total, this.prev, this.next, this.dashboards);
    }

    public String prev() {
        return this.prev;
    }

    public DashboardsBean prev(String previous) {
        return new DashboardsBean(this.startAt, this.maxResults, this.total, previous, this.next, this.dashboards);
    }

    public String next() {
        return this.next;
    }

    public DashboardsBean next(String next) {
        return new DashboardsBean(this.startAt, this.maxResults, this.total, this.prev, next, this.dashboards);
    }

    public List<DashboardBean> dashboards() {
        return this.dashboards;
    }

    public DashboardsBean dashboards(List<DashboardBean> dashboards) {
        return new DashboardsBean(this.startAt, this.maxResults, this.total, this.prev, this.next, dashboards);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DashboardsBean that = (DashboardsBean)o;
        if (this.dashboards != null ? !this.dashboards.equals(that.dashboards) : that.dashboards != null) {
            return false;
        }
        if (this.maxResults != null ? !this.maxResults.equals(that.maxResults) : that.maxResults != null) {
            return false;
        }
        if (this.next != null ? !this.next.equals(that.next) : that.next != null) {
            return false;
        }
        if (this.prev != null ? !this.prev.equals(that.prev) : that.prev != null) {
            return false;
        }
        if (this.startAt != null ? !this.startAt.equals(that.startAt) : that.startAt != null) {
            return false;
        }
        return !(this.total != null ? !this.total.equals(that.total) : that.total != null);
    }

    public int hashCode() {
        int result = this.startAt != null ? this.startAt.hashCode() : 0;
        result = 31 * result + (this.maxResults != null ? this.maxResults.hashCode() : 0);
        result = 31 * result + (this.total != null ? this.total.hashCode() : 0);
        result = 31 * result + (this.prev != null ? this.prev.hashCode() : 0);
        result = 31 * result + (this.next != null ? this.next.hashCode() : 0);
        result = 31 * result + (this.dashboards != null ? this.dashboards.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "DashboardsBean{startAt=" + this.startAt + ", maxResults=" + this.maxResults + ", total=" + this.total + ", previous='" + this.prev + "', next='" + this.next + "', dashboards=" + this.dashboards + "}";
    }
}

