require([
    'jquery',
    'underscore',
    'wrm/require',
    'quick-edit/util/loading-indicator',
    'jira/ajs/keyboardshortcut/keyboard-shortcut-toggle'
], function (
    jQuery,
    _,
    wrmRequire,
    LoadingIndicator,
    KeyboardShortcutToggle
) {
        var showLoadingIndicator = function () {
            KeyboardShortcutToggle.disable();
            LoadingIndicator.showLoadingIndicator();
        };
        var hideLoadingIndicator = function () {
            LoadingIndicator.hideLoadingIndicator(true);
            KeyboardShortcutToggle.enable();
        };

        var dialog;
        var bootstrapFunction = function (event) {
            event.preventDefault();
            showLoadingIndicator();
            var resourceKey = 'wr!com.atlassian.jira.jira-quick-edit-plugin:quick-edit-issue';
            var wrmRequireDeferred = wrmRequire([resourceKey]);
            wrmRequireDeferred.done(function () {
                var initEditDialogFactory = require('quick-edit/init/edit');
                // Creates edit issue dialog
                if (!dialog) {
                    dialog = initEditDialogFactory.initDialog();
                }
                dialog._events.trigger.simpleClick.call(dialog, event, jQuery(event.target));
                KeyboardShortcutToggle.enable();
            }).fail(function onFail() {
                hideLoadingIndicator();
            });
        };

        jQuery(document).delegate('.issueaction-edit-issue', 'click', bootstrapFunction);
});


