/**
 * @module quick-edit/form/factory/create-issue
 */
define('quick-edit/form/factory/create-issue', [
    'quick-edit/form/container',
    'quick-edit/form/configurable/create-issue',
    'quick-edit/form/unconfigurable-create-issue',
    'quick-edit/form/error/create-issue',
    'quick-edit/form/model/create-issue'
], function(
    Container,
    ConfigurableCreateIssueForm,
    UnconfigurableCreateIssueForm,
    CreateIssueError,
    CreateIssueModel
){
    'use strict';

    /**
     * Factory to create Create Issue Form.
     *
     * @return FormContainer
     */
     return function (options) {
        options = options || {};

        return new Container(function () {
            options.globalEventNamespaces = options.globalEventNamespaces || ["QuickCreateIssue"];

            // model that gets fields and sets user preferences
            var title = AJS.I18n.getText('admin.issue.operations.create'),
                model = new CreateIssueModel({
                    projectId: options.pid,
                    issueType: options.issueType
                }),
                configurableForm = new ConfigurableCreateIssueForm({
                    model: model,
                    title: title,
                    globalEventNamespaces: options.globalEventNamespaces
                }),
                unconfigurableForm = new UnconfigurableCreateIssueForm({
                    model: model,
                    title: title,
                    globalEventNamespaces: options.globalEventNamespaces
                });

            return {
                globalEventNamespaces: options.globalEventNamespaces,
                model: model,
                errorHandler: new CreateIssueError(),
                configurableForm: configurableForm,
                unconfigurableForm: unconfigurableForm
            };
        });
    };
});

/**
 * @deprecated JIRA.Forms.createCreateIssueForm
 */
AJS.namespace('JIRA.Forms.createCreateIssueForm', null, require('quick-edit/form/factory/create-issue'));