/**
 * @module quick-edit/create-linked-issue/create-linked-issue-form-model
 */
define('quick-edit/create-linked-issue/create-linked-issue-form-model', [
    'quick-edit/form/model/create-issue',
    'jira/issue',
    'wrm/context-path',
    'jquery'
], function(
    CreateIssueFormModel,
    JiraIssue,
    contextPath,
    jQuery
){
    'use strict';

    /**
     * A special Model for create linked issue
     *
     * @class CreateLinkedIssueFormModel
     * @extends CreateIssueFormModel
     */
    return CreateIssueFormModel.extend({

        getFieldsResource: function () {
            return  contextPath() + "/secure/QuickCreateLinkedIssue!default.jspa?decorator=none&sourceIssueKey=" + JiraIssue.getIssueKey();
        },

        // Prevent any side-effects to update user preference as we don't show the Configure Fields toolbar
        updateUserPrefs: function (data) {
            var deferred = jQuery.Deferred();
            deferred.done();

            return deferred.promise();
        },

        // Default fields to show: Issue Links, Summary, Description and required fields
        // Default fields to hide: Reporter, Assignee
        getActiveFieldIds: function () {
            var deferred = jQuery.Deferred(),
                activeFieldIds = ["issuelinks", "summary", "description", "copyLinks", "copyAttachments"];

            this.getFields().done(function (fields) {
                jQuery.each(fields, function (i, field) {
                    if (field.required && field.id !== "reporter" && field.id !== "assignee") {
                        activeFieldIds.push(field.id);
                    }
                });

                deferred.resolve(activeFieldIds);
            });

            return deferred.promise();
        },

        _update: function (data) {
            CreateIssueFormModel.prototype._update.apply(this, arguments);
            this.displayCopyAttachments = data.displayCopyAttachments;
            this.displayCopyLinks = data.displayCopyLinks;
            this.postIssueCreationErrorMessages = data.postIssueCreationErrorMessages;
        },

        shouldDisplayCopyAttachments: function () {
            return this.displayCopyAttachments;
        },

        shouldDisplayCopyLinks: function () {
            return this.displayCopyLinks;
        },

        getPostIssueCreationErrorMessages: function () {
            return this.postIssueCreationErrorMessages;
        }
    });
});
