/**
 * @module quick-edit/create-linked-issue/create-linked-issue-form-factory
 */
define('quick-edit/create-linked-issue/create-linked-issue-form-factory', [
    'quick-edit/create-linked-issue/create-linked-issue-form',
    'quick-edit/create-linked-issue/create-linked-issue-form-model',
    'quick-edit/form/container',
    'quick-edit/form/error/create-issue'
], function(
    CreateLinkedIssueForm,
    CreateLinkedIssueModel,
    Container,
    CreateIssueError
){
    'use strict';

    /**
     * Factory to create Create Linked Issue Form.
     *
     * @return FormContainer
     */
    return function (options) {
        options = options || {};

        return new Container(function () {
            options.globalEventNamespaces = options.globalEventNamespaces || ["CreateLinkedIssue"];

            var title = AJS.I18n.getText('createlinkedissue.title'),
                model = new CreateLinkedIssueModel({
                    projectId: options.pid,
                    issueType: options.issueType
                }),
                form = new CreateLinkedIssueForm({
                    model: model,
                    title: title,
                    globalEventNamespaces: options.globalEventNamespaces
                });

            return {
                globalEventNamespaces: options.globalEventNamespaces,
                model: model,
                errorHandler: new CreateIssueError(),
                configurableForm: form,
                unconfigurableForm: form
            };
        });
    };
});
