AJS.test.require("com.atlassian.jira.jira-quick-edit-plugin:quick-create-issue");
AJS.test.require("com.atlassian.jira.jira-quick-edit-plugin:test-util");
module("Serialize For Toggling Screens",{setup:function(){var A;
var B;
this.formStub={model:{hasRetainFeature:function(){return true
}},getForm:function(){return{serializeArray:function(){return A
}}
},getActiveFieldIds:function(){return B
}};
this.project={name:"pid",value:"monkey"};
this.issueType={name:"issuetype",value:"1"};
this.setFormSerializeResult=function(C){A=C
};
this.setActiveFieldIds=function(C){B=C
};
this.helper=new JIRA.Forms.CreateIssueHelper(this.formStub)
}});
test("Serializing when toggling excludes doesn't retain project and issuetype but does serialize",function(){this.setActiveFieldIds(["summary","priority"]);
this.setFormSerializeResult([this.project,this.issueType,{name:"summary",value:"My Summary"},{name:"priority",value:"minor"}]);
var A=this.helper.serializeForToggle();
ok(A.indexOf("issuetype=1")!==-1,"Should still serialize");
equal(A.indexOf("fieldsToRetain=issuetype"),-1,"Expected issue type not to be retained");
ok(A.indexOf("pid=monkey")!==-1,"Should still serialize");
equal(A.indexOf("fieldsToRetain=pid"),-1,"Expected project not to be retained")
});
test("The serialized value does not change if I call it twice",function(){this.setActiveFieldIds(["summary","priority"]);
this.setFormSerializeResult([this.project,this.issueType,{name:"summary",value:"My Summary"},{name:"priority",value:"minor"}]);
equal(this.helper.serializeForToggle(),"retainValues=true&summary=My+Summary&priority=minor&pid=monkey&issuetype=1&toggle=true&fieldsToRetain=summary&fieldsToRetain=priority","Only priority and summary fields should be retained");
equal(this.helper.serializeForToggle(),"retainValues=true&summary=My+Summary&priority=minor&pid=monkey&issuetype=1&toggle=true&fieldsToRetain=summary&fieldsToRetain=priority","Only priority and summary fields should be retained")
});
test("Fields that are not active do NOT get remembered but do get serialized",function(){this.setActiveFieldIds(["summary","priority"]);
this.setFormSerializeResult([this.project,this.issueType,{name:"summary",value:"My Summary"},{name:"priority",value:"minor"},{name:"dontremember",value:"bogus"}]);
var A=this.helper.serializeForToggle();
equal(A.indexOf("fieldsToRetain=dontremember"),-1,"Expected issue type not to be retained")
});
test("If I change the active fields, the previous active should still be remembered",function(){var A;
this.setActiveFieldIds(["summary","priority","components"]);
this.setFormSerializeResult([this.project,this.issueType,{name:"summary",value:"My Summary"},{name:"priority",value:"minor"},{name:"components",value:"blah"}]);
A=this.helper.serializeForToggle();
this.setActiveFieldIds(["summary","priority"]);
A=this.helper.serializeForToggle();
ok(A.indexOf("fieldsToRetain=components")!==-1,"Expected components still to be retained");
ok(A.indexOf("fieldsToRetain=summary")!==-1);
ok(A.indexOf("fieldsToRetain=priority")!==-1);
ok(A.indexOf("components=blah")!==-1,"Value should be remembered")
});
test("Currently active field values replace previously active",function(){var A;
this.setActiveFieldIds(["summary","priority","components"]);
this.setFormSerializeResult([this.project,this.issueType,{name:"summary",value:"My Summary"},{name:"priority",value:"minor"},{name:"components",value:"blah"}]);
A=this.helper.serializeForToggle();
this.setActiveFieldIds(["summary","priority","components"]);
this.setFormSerializeResult([this.project,this.issueType,{name:"summary",value:"My Summary"},{name:"priority",value:"minor"},{name:"components",value:"UPDATED"}]);
A=this.helper.serializeForToggle();
ok(A.indexOf("components=UPDATED")!==-1,"components field value should be the updated one")
});