AJS.test.require("com.atlassian.jira.jira-quick-edit-plugin:quick-create-issue");
AJS.test.require("com.atlassian.jira.jira-quick-edit-plugin:test-util");
test("visibility feature only for optional fields",function(){var A=new JIRA.Forms.CreateIssueModel();
ok(!A.hasVisibilityFeature({editHtml:"<input />",label:"blah",required:true}),"Expected required fields NOT to have visibility feature");
ok(A.hasVisibilityFeature({editHtml:"<input />",label:"blah"}),"Expected optional fields to have visibility feature")
});
test("getConfigurableFields",function(){var A=new JIRA.Forms.CreateIssueModel();
A.setFields([{id:"project"},{id:"issuetype"},{id:"components"}]);
A.getConfigurableFields().done(function(B){deepEqual(B,[{id:"components"}],"Expected project & issueType fields to be excluded as configurable fields")
})
});
test("getIssueSetupFields",function(){var A=new JIRA.Forms.CreateIssueModel();
A.setFields([{id:"project"},{id:"issuetype"},{id:"components"}]);
A.getIssueSetupFields().done(function(B){deepEqual(B,[{id:"project"},{id:"issuetype"}],"Expected project & issueType fields to be excluded as configurable fields")
})
});
test("non retained fields should not be retained",function(){var A=new JIRA.Forms.CreateIssueModel();
A.addFieldToRetainValue("summary",false);
A.addFieldToRetainValue("description",false);
A.addFieldToRetainValue("timetracking",false);
A.addFieldToRetainValue("timetracking_originalestimate",false);
A.addFieldToRetainValue("timetracking_remainingestimate",false);
ok(!A.hasRetainedValue({id:"summary"}),"Expected [summary] value NOT to be retained, it should have been removed");
ok(!A.hasRetainedValue({id:"description"}),"Expected [description] value NOT to be retained, it should have been removed");
ok(!A.hasRetainedValue({id:"timetracking"}),"Expected [timetracking] value NOT to be retained, it should have been removed");
ok(!A.hasRetainedValue({id:"timetracking_originalestimate"}),"Expected [timetracking_originalestimate] value NOT to be retained, it should have been removed");
ok(!A.hasRetainedValue({id:"timetracking_remainingestimate"}),"Expected [timetracking_remainingestimate] value NOT to be retained, it should have been removed")
});
test("non retained fields should not be retained even when forced",function(){var A=new JIRA.Forms.CreateIssueModel();
A.addFieldToRetainValue("description",false);
ok(!A.hasRetainedValue({id:"description"}),"Expected [description] value NOT to be retained, it should have been removed")
});