AJS.test.require("com.atlassian.jira.jira-projects-plugin:unlicensed-project-type", function() {
    "use strict";

    var jQuery = require("jquery");
    var wrmContextPath = require("wrm/context-path");
    var Templates = require("jira/projects/unlicensed/templates");
    var Renderer = require("jira/projects/unlicensed/view/renderer");

    module("jira/projects/unlicensed/view/renderer", {

        renderUsingAppNameWith: function(templateParams) {
            templateParams.applicationName = "JIRA Software";
            return Renderer.renderUsingAppName(templateParams);
        },

        renderWith: function(templateParams) {
            templateParams.projectTypeName = "any-name";
            return Renderer.render(templateParams);
        },

        getFooterText: function(html) {
            return jQuery(html).find("footer").text();
        },

        getLinkWithHref: function(html, href) {
            return jQuery(html).find("a[href='" + href + "']").eq(0);
        }
    });

    test("When getting the template using application name, it should return the expected template", function(){
        var returnedTemplate = Renderer.getTemplateUsingAppName();

        strictEqual(returnedTemplate, Templates.unlicensedViewUsingAppName);
    });
    test("When it renders the template using application name, it should renders the 'Continue to project' link if a redirect url is passed", function() {
        var html = this.renderUsingAppNameWith({
            projectRedirectUrl: "redirect-url"
        });

        var link = this.getLinkWithHref(html, "redirect-url");
        equal(link.text(), "jira.projects.unlicensed.continue.to.project");
    });

    test("When it renders the template using application name, it should renders the 'Continue to JIRA Home' link if a redirect url is not passed", function() {
        var html = this.renderUsingAppNameWith({});

        var link = this.getLinkWithHref(html, wrmContextPath());
        equal(link.text(), "jira.projects.unlicensed.continue.to.jira.home");
    });

    test("When it renders the template using application name, it should render the 'request application access' link if url for that is passed", function() {
        var html = this.renderUsingAppNameWith({
            requestApplicationAccessUrl: "application-access-url"
        });

        equal(this.getFooterText(html), "jira.projects.unlicensed.type.footer.including.admin.form");
    });

    test("When it renders the template using application name, it should not render the 'request application access' link if url for that is not passed", function() {
        var html = this.renderUsingAppNameWith({});

        equal(this.getFooterText(html), "jira.projects.unlicensed.type.footer");
    });

    test("getTemplate returns the expected template", function(){
        var returnedTemplate = Renderer.getTemplate();

        strictEqual(returnedTemplate, Templates.unlicensedView);
    });

    test("Render renders the 'Continue to project' link if a redirect url is passed", function() {
        var html = this.renderWith({
            projectRedirectUrl: "redirect-url"
        });

        var link = this.getLinkWithHref(html, "redirect-url");
        equal(link.text(), "jira.projects.unlicensed.continue.to.project");
    });

    test("Render renders the 'Continue to JIRA Home' link if a redirect url is not passed", function() {
        var html = this.renderWith({});

        var link = this.getLinkWithHref(html, wrmContextPath());
        equal(link.text(), "jira.projects.unlicensed.continue.to.jira.home");
    });

    test("Render renders the 'Request a license' link if url for that is passed", function() {
        var html = this.renderWith({
            requestLicenseUrl: "license-url"
        });

        equal(this.getFooterText(html), "jira.projects.unlicensed.type.footer.including.admin.form");
    });

    test("Render does not render the 'Request a license' link if url for that is not passed", function() {
        var html = this.renderWith({});

        equal(this.getFooterText(html), "jira.projects.unlicensed.type.footer");
    });
});
