AJS.test.require("com.atlassian.jira.jira-projects-plugin:pinnablenavigator-test",function(){var g=require("underscore"),h=require("jira-projects-backbone"),k=require("jira/projects/components/pinnable-navigator/entities/items"),a={id:"item1",label:"Item 1"},b={id:"item2",label:"Item 2"},e={id:"item3",label:"Item 3"},c=[{items:[a],id:"group1"},{items:[b],id:"group2"}],f=[{items:[a]},{items:[b]},{items:[e],type:"buttons"}];module("jira/projects/components/pinnable-navigator/entities/items",{setup:function(){this.model=
new k({})}});test("Is empty when given list of items is undefined",function(){this.model.set("itemGroups",void 0);strictEqual(this.model.isEmpty(),!0)});test("Is empty when given list of items is empty",function(){this.model.set("itemGroups",[]);strictEqual(this.model.isEmpty(),!0)});test("Is not empty when the list of items contains something",function(){this.model.set("itemGroups",["item1"]);strictEqual(this.model.isEmpty(),!1)});test("Keeps a reference to the selected item when there is one with the given id",
function(){this.model.set("itemGroups",c);this.model.selectItem(b.id);equal(this.model.get("selectedItem"),b)});test("Sets the selected item to the first one if there is no item with the given id",function(){this.model.set("itemGroups",c);this.model.selectItem("nonexistentItem");equal(this.model.get("selectedItem"),a)});test("Sets the selected item to undefined if there is no item with the given id and the list of items is empty",function(){this.model.set("itemGroups",[]);this.model.selectItem(a.id);
equal(this.model.get("selectedItem"),void 0)});test("Sets the selected item to undefined if there is no item with the given id and the list of items is undefined",function(){this.model.set("itemGroups",void 0);this.model.selectItem(a.id);equal(this.model.get("selectedItem"),void 0)});test("Triggers a 'change:selectedItem' event when an item is selected",function(){var a=this.spy();g.extend({},h.Events).listenTo(this.model,"change:selectedItem",a);this.model.set("itemGroups",c);this.model.selectItem(b.id);
sinon.assert.calledOnce(a)});test("Returns a flat version of the items list when asked for all items",function(){this.model.set("itemGroups",c);var d=this.model.getAllItems();deepEqual(d,[a,b])});test("Returns all real items (except buttons such as New Queue or New Report)",function(){this.model.set("itemGroups",f);var d=this.model.getAllItemsExceptButtons();deepEqual(d,[a,b])});test("Returns all items which match with given name",function(){this.model.set("itemGroups",f);var a=this.model.getAllItemsWithName("item 2");
deepEqual(a,[{items:[b]},{items:[e],type:"buttons"}])});test("Test not manageable if no items in manageble group",function(){this.model.set("itemGroups",[{allowDelete:!0,items:[]},{items:[a]}]);ok(!this.model.isManageable(),"Expected group not to be manageable")});test("Test not manageable if no allowDelete or allowReorder",function(){this.model.set("itemGroups",[{items:[]},{items:[a]}]);ok(!this.model.isManageable(),"Expected group not to be manageable")});test("Test is manageable",function(){this.model.set("itemGroups",
[{items:[]},{allowDelete:!0,items:[a]}]);ok(this.model.isManageable(),"Expected group to be manageable")});test("Test hasDisplayableGroups",function(){this.model.set("itemGroups",[{items:[]}]);ok(!this.model.hasDisplayableGroups());this.model.set("itemGroups",[{emptyText:"empty",items:[]}]);ok(this.model.hasDisplayableGroups());this.model.set("itemGroups",[{items:[a]}]);ok(this.model.hasDisplayableGroups())})});