define('jira/projects/sidebar/scopefilter/model', ['underscore'], function (_) {
    'use strict';

    var Model = function (data) {
        this.selectedScope = null;
        this.createScopeActions = [];
        this.selectableScopes = [];
        // we need to update data after creation of model, hence a separate method
        this.setData(data);
    };

    Model.prototype.setData = function (data) {
        if(!data){
            return;
        }
        if (data.selectedScope) {
            this.selectedScope = data.selectedScope;
        }
        if (data.createScopeActions.length) {
            this.createScopeActions = data.createScopeActions;
        }
        if (data.scopes.length) {
            // if there are scopes and selectedScope in initial load, this means we are using old plugin point (no lazy load)
            if (data.selectedScope) {
                this.selectableScopes = _.reject(data.scopes, function (scope) {
                    return scope.label === this.selectedScope.label && scope.link === this.selectedScope.link;
                }, this);
            } else {
                this.selectableScopes = data.scopes;
            }
        }
    };

    Model.prototype.getSelectedScope = function () {
        return this.selectedScope
    };

    Model.prototype.getSelectableScopes = function () {
        return this.selectableScopes;
    };

    Model.prototype.getCreateScopeActions = function () {
        return this.createScopeActions;
    };

    Model.prototype.shouldDisplayWhenSidebarIsCollapsed = function () {
        var userCanCreateAScope = this.createScopeActions.length > 0;
        var thereAreScopesToSelect = this.selectableScopes.length > 0;
        return userCanCreateAScope || thereAreScopesToSelect;
    };

    return Model;
});

AJS.namespace('JIRA.Projects.Sidebar.ScopeFilter.Model', null, require('jira/projects/sidebar/scopefilter/model'));
