define('jira/projects/sidebar/scopefilter/collapsed-view', [
    'jquery',
    'jira/projects/libs/marionette',
    'jira/projects/sidebar/scopefilter/templates'
], function ($, Marionette, Templates) {
    'use strict';

    return Marionette.ItemView.extend({
        template: Templates.collapsedContainer,
        ui: {
            trigger: '.aui-sidebar-group-actions'
        },
        events: {
            'aui-sidebar-submenu-before-show @ui.trigger': 'show'
        },
        initialize: function (options) {
            this.controller = options.controller;
            this.rendered = false;
        },
        serializeData: function () {
            return {
                selectedScope: this.model.getSelectedScope(),
                selectableScopes: this.model.getSelectableScopes(),
                createActions: this.model.getCreateScopeActions()
            }
        },
        show: function (event, inlineDialog) {
            if (this.rendered) { // if we already fetched data from server and updated DOM then don't repeat it
                return
            }

            this.$el.addClass('data-load-in-progress');
            this.controller.fetchScopeFilterList()
                .then(this.onFetchSuccess.bind(this, inlineDialog))
                .fail(this.onFetchFail.bind(this, inlineDialog))
                .always(function () {
                    this.$el.addClass('data-load-finished').removeClass('data-load-in-progress');
                }.bind(this));
        },
        onFetchSuccess: function(inlineDialog) {
            this.$el.addClass('data-load-success');
            var html = Templates.collapsedScopeList(this.serializeData());
            this.renderPreparedTemplate(inlineDialog, html);
            this.rendered = true;
        },
        onFetchFail: function(inlineDialog) {
            this.$el.addClass('data-load-fail');
            var html = Templates.scopeListError();
            this.renderPreparedTemplate(inlineDialog, html);
            $(inlineDialog).find('.scope-filter-error-message-container .aui-button')
                .click(this.onRetryClick.bind(this, inlineDialog));
        },
        renderPreparedTemplate: function (inlineDialog, template) {
            // update the DOM so that AUI will pick up this content in next hover
            this.ui.trigger.html(template);
            // manually update the currently displayed inline dialog with progressbar
            $(inlineDialog).find('.aui-navgroup-inner').html(template);
        },
        onRetryClick: function (inlineDialog) {
            return this.show(null, inlineDialog);
        }
    });
});

AJS.namespace('JIRA.Projects.Sidebar.ScopeFilter.CollapsedView', null, require('jira/projects/sidebar/scopefilter/collapsed-view'));
