require([
    "jira/projects/sidebar/project-shortcuts/analytics",
    "jira/projects/sidebar/project-shortcuts/views/list",
    "jira/projects/sidebar/project-shortcuts/services/available-icons",
    "jira/projects/sidebar/project-shortcuts/entities/shortcuts",
    "jira/api/projects/sidebar",
    "jira/api/projects",
    "wrm/data"
], function(
    PSAnalytics,
    PSListView,
    AvailableIcons,
    PSShortcuts,
    SidebarAPI,
    ProjectsAPI,
    wrmData
) {
    "use strict";

    SidebarAPI.getSidebar().done(function(sidebar) {

        var projectId = wrmData.claim('com.atlassian.jira.projects.shortcuts:project-id');
        PSAnalytics.initialize(projectId);

        // Start everything up only if user can manage project shortcuts
        if (wrmData.claim('com.atlassian.jira.projects.shortcuts:can-manage')) {

            var isWithIcons = wrmData.claim('com.atlassian.jira.projects.shortcuts:with-icons');

            if (isWithIcons) {
                AvailableIcons.initialize(wrmData.claim('com.atlassian.jira.projects.shortcuts:icons-list'));
            }
            AvailableIcons.setWithIcons(isWithIcons);

            var projectKey = ProjectsAPI.getCurrentProjectKey();

            var shortcutsCollection = new PSShortcuts(
                wrmData.claim('com.atlassian.jira.projects.shortcuts:shortcuts'),
                { projectKey: projectKey }
            );

            var shortcutsView = new PSListView({
                collection: shortcutsCollection,
                targetGroup: 'project-shortcuts-group'
            });
            shortcutsView.render();

            PSAnalytics.initDialogActions(shortcutsView);
        }

        PSAnalytics.initShortcutClick('.project-shortcuts-list', sidebar);
    });
});
