AJS.test.require(["com.atlassian.jira.jira-projects-plugin:sidebar-project-shortcuts"], function(){
    "use strict";

    var Backbone = require("jira-projects-backbone");
    var PSShortcutErrors = require("jira/projects/sidebar/project-shortcuts/entities/shortcut-errors");

    module('jira/projects/sidebar/project-shortcuts/entities/shortcut-errors', {
        setup: function () {
            this.model = new Backbone.Model();
            this.errorModel = new PSShortcutErrors(undefined, {
                model: this.model
            });
        },
        assertFailureEvents: function(name) {
            this.model.trigger(name+":failure", {
                message: "auth error",
                errors: {}
            });
            this.assertModelData("auth error");

            this.model.trigger(name+":failure", {
                errorMessages: ["global error"]
            });
            this.assertModelData("global error");

            this.model.trigger(name+":failure", {
                errorMessages: ["global error"]
            });
            this.assertModelData("global error");

            this.model.trigger(name+":failure", {
                errors: {
                    url: 'url error',
                    name: 'name error'
                }
            });
            this.assertModelData(undefined, "url error", "name error");

        },
        assertModelData: function(generalError, urlError, nameError) {
            equal(this.errorModel.get("generalError"), generalError, "General error is present");
            equal(this.errorModel.get("urlError"), urlError, "Url error is not present");
            equal(this.errorModel.get("nameError"), nameError, "Name error is not present");
        }
    });

    test('Should pick up errors on save failure.', function () {
        this.assertFailureEvents("save");
    });

    test('Should pick up errors on remove failure.', function () {
        this.assertFailureEvents("remove");
    });

    test('Should clear errors successful save.', function () {
        this.assertFailureEvents("save");
        this.model.trigger("save:success");
        this.assertModelData(undefined, undefined, undefined);
    });

    test('Should clear errors successful remove.', function () {
        this.assertFailureEvents("remove");
        this.model.trigger("remove:success");
        this.assertModelData(undefined, undefined, undefined);
    });
});

