define('jira/projects/sidebar/project-shortcuts/dialogs/edit', [
    "jira/projects/sidebar/project-shortcuts/templates",
    "jira/projects/sidebar/project-shortcuts/views/edit-dialog-content",
    "jira/projects/sidebar/project-shortcuts/entities/shortcut",
    "jira/projects/sidebar/project-shortcuts/entities/shortcut-errors",
    "jira/projects/libs/marionette",
    "underscore",
    "jquery"
], function(
    Templates,
    EditDialogContentView,
    PSShortcut,
    PSShortcutErrors,
    Marionette,
    _,
    jQuery
) {
    "use strict";

    return Marionette.Controller.extend({
        initialize: function(options) {
            var instance = this;
            _.bindAll(this, "hide");

            this.model = new PSShortcut(options.model.toJSON(), {
                projectKey: options.model.projectKey || options.model.collection.projectKey
            });
            this.errorModel = new PSShortcutErrors(undefined, {
                model: this.model
            });
            this.view = new EditDialogContentView({
                model: this.model,
                errorModel: this.errorModel
            });
            this.analyticsSave = false;

            this.view.render();
            var $dialogElement = jQuery(Templates.editDialogChrome({}));
            this.view.$el.appendTo($dialogElement);
            this.dialog = AJS.dialog2($dialogElement);
            this.dialog.show();
            this.view.ui.url.focus();

            this._onResizeWindow = function() {
                instance.hideIconPicker();
            };
            jQuery(window).on('resize', this._onResizeWindow);

            this.listenTo(this.view, 'cancel', this.hide);
            this.listenTo(this.model, 'save:success', function onSave() {
                this.analyticsSave = true;
                this.hide();
                options.model.set(instance.model.toJSON());
            });
            this.dialog.on("hide", function onDialogHide() {
                instance.trigger("dialog:close", instance.analyticsSave);
            });
        },

        hideIconPicker: function() {
            this.view.hideIconPicker();
        },

        hide: function hide() {
            this.dialog.hide();
            jQuery(window).off('resize', this._onResizeWindow);
        }
    });
});

AJS.namespace('JIRA.Projects.Sidebar.ProjectShortcuts.Dialogs.Edit', null, require('jira/projects/sidebar/project-shortcuts/dialogs/edit'));
