define("jira/projects/sidebar/lastvisited/updater", [
    "jira/api/projects",
    "jira/util/logger",
    "wrm/context-path",
    "jquery"
], function(
    ProjectsAPI,
    logger,
    wrmContextPath,
    $
) {
    "use strict";

    function updateLastViewedItem(projectKey, selectedItemId, callback) {
        if (!projectKey) {
            return;
        }

        callback = callback || function () {
            logger.trace("last.visited.item.saved");
        };
        $.ajax({
            url: wrmContextPath() + "/rest/projects/1.0/project/" + encodeURIComponent(projectKey) + "/lastVisited",
            type: "PUT",
            contentType: "application/json",
            data: JSON.stringify({
                id: selectedItemId
            })
        }).done(callback);
    }


    return {
        start: function (sidebar, callback) {
            var currentProjectKey = ProjectsAPI.getCurrentProjectKey();
            var selectedNavItem = sidebar.getSelectedNavigationItem();
            if (selectedNavItem) {
                updateLastViewedItem(currentProjectKey, selectedNavItem.getId(), callback);
            }
            sidebar.on("before:navigate:prevented", function (event) {
                updateLastViewedItem(currentProjectKey, event.emitter.id, callback);
            });
            sidebar.on("before:select", function (event) {
                if (event.isInitial) {
                    updateLastViewedItem(currentProjectKey, event.emitter.id, callback);
                }
            });
        }
    };
});

AJS.namespace("JIRA.Projects.Sidebar.LastVisited.Updater", null, require("jira/projects/sidebar/lastvisited/updater"));
