AJS.test.require("com.atlassian.jira.jira-projects-plugin:summary-page-initial-redirect-to-issuenav", function() {
    "use strict";

    var jQuery = require("jquery");
    var ProjectsAPI = require("jira/api/projects");
    var Browser = require("jira/projects/util/browser");
    var RedirectToIssueNav = require("jira/projects/summary/redirecttoissuenav");

    module("jira/projects/summary/redirecttoissuenav", {
        setup: function () {
            this.sandbox = sinon.sandbox.create();
            this.el = jQuery("<div></div>");

            this.mockProjectKey();
        },

        tearDown: function () {
            this.sandbox.restore();
        },

        mockProjectKey: function() {
            sinon.stub(ProjectsAPI, "getCurrentProjectKey", function() {
                return "KEY";
            });
        }
    });

    test("When a 'sessionComplete' event is triggered from the quick create issue dialog, it redirects to the sidebar issue nav", function () {
        var redirect = sinon.stub(Browser, "locationAssign");
        RedirectToIssueNav.start(this.el);

        jQuery(this.el).trigger("QuickCreateIssue.sessionComplete");

        sinon.assert.calledOnce(redirect);
    });
});
