define("jira/projects/page/summary/navigation/navigation-analytics", ["jira/analytics", "exports"], function(analytics, exports) {
    "use strict";

    var triggerAnalyticsEventWithName = function(name) {
        analytics.send({
            name: name
        });
    };

    var NavigationAnalytics = function () {
        return {
            start: function (navigation) {
                navigation.on({
                    "statisticsPageSelected": function () {
                        triggerAnalyticsEventWithName("jira.projects.summary.page.issue.statistics.selected");
                    },
                    "activityPageSelected": function () {
                        triggerAnalyticsEventWithName("jira.projects.summary.page.activity.stream.selected");
                    }
                });
            }
        };
    };

    exports.create = function () {
        return new NavigationAnalytics();
    };
});

AJS.namespace("JIRA.Projects.Summary.NavigationAnalytics", null, require("jira/projects/page/summary/navigation/navigation-analytics"));
