define("jira/projects/page/summary/issue/vignettes/lastviewed/manager", [
    "jira/util/users/logged-in-user",
    "wrm/context-path",
    "jquery"
], function(loggedInUser, wrmContextPath, $) {
    "use strict";

    var propertyUpdateUrl = wrmContextPath()
                    + "/rest/api/2/user/properties/lastViewedVignette?username="
                    + loggedInUser.username();

    var lastViewedVignetteRequest = function(method, data) {
        return $.ajax({
            contentType: "application/json",
            data: JSON.stringify(data),
            type: method,
            url: propertyUpdateUrl
        });
    };

    return {
        updateLastViewedVignette: function(vignetteId) {
            lastViewedVignetteRequest("PUT", { id: vignetteId });
        },

        getLastViewedVignette: function() {
            return lastViewedVignetteRequest("GET");
        }
    };
});
