AJS.test.require("com.atlassian.jira.jira-projects-plugin:summary-page-issue-vignettes-last-viewed-vignette-manager-test-resources", function() {
    "use strict";

    var jQuery = require("jquery");
    var wrmContextPath = require("wrm/context-path");
    var loggedInUser = require("jira/util/users/logged-in-user");

    module("jira/projects/page/summary/issue/vignettes/lastviewed/manager", {
        setup: function() {
            this.lastViewedUpdater = require("jira/projects/page/summary/issue/vignettes/lastviewed/manager");

            this.propertyUpdateUrl = wrmContextPath() +
                "/rest/api/2/user/properties/lastViewedVignette?username=" +
                loggedInUser.username();
        },

        requestObjectWithMethodAndData: function(method, data) {
            return {
                contentType: "application/json",
                data: JSON.stringify(data),
                type: method,
                url: this.propertyUpdateUrl
            };
        }
    });

    test("When updating the last viewed vignette, the correct ajax call is made", function() {
        this.stub(jQuery, "ajax");
        var vignetteId = "vignette-id";

        this.lastViewedUpdater.updateLastViewedVignette(vignetteId);

        sinon.assert.calledOnce(jQuery.ajax);
        sinon.assert.calledWith(jQuery.ajax, this.requestObjectWithMethodAndData("PUT", { id: vignetteId }));
    });

    test("When getting the last viewed vignette, the correct ajax call is made", function() {
        this.stub(jQuery, "ajax");

        this.lastViewedUpdater.getLastViewedVignette();

        sinon.assert.calledOnce(jQuery.ajax);
        sinon.assert.calledWith(jQuery.ajax, this.requestObjectWithMethodAndData("GET"));
    });
});
