require([
    "jira/api/projects",
    "jira/projects/components/subnavigator/subnavigator",
    "jira/util/formatter",
    "wrm/context-path",
    "wrm/data",
    "underscore",
    "jquery"
], function(
    ProjectsAPI,
    Subnavigator,
    formatter,
    wrmContextPath,
    wrmData,
    _,
    $
) {
    "use strict";

    function isCurrentlyViewingSidebarProjectPage() {
        return ProjectsAPI.getCurrentProjectKey() !== undefined;
    }

    $(function() {
        if(isCurrentlyViewingSidebarProjectPage()) {
            var triggerPlaceholder = $("#version-subnav-trigger");
            var contentPlaceholder = $("#version-subnav-content");
            var titlePlaceholder = $("#version-subnav-header");
            var allVersions = _.map(wrmData.claim("com.atlassian.jira.project.browse.version:versions"), function (versionView) {
                return {
                    id: versionView.id,
                    label: versionView.name,
                    description: versionView.description,
                    link: versionView.url
                };
            });
            var selectedVersionId = wrmData.claim("com.atlassian.jira.project.browse.version:selectedVersionId");

            var subnavigator = new Subnavigator({
                id: "versions",
                triggerPlaceholder: triggerPlaceholder,
                contentPlaceholder: contentPlaceholder,
                titlePlaceholder: titlePlaceholder,
                itemGroups: [allVersions, [{
                    id: "com.atlassian.jira.jira-projects-plugin:release-page",
                    label: formatter.I18n.getText("project.page.release.subnavigator.item.all"),
                    description: formatter.I18n.getText("project.page.release.subnavigator.item.all.description"),
                    link: wrmContextPath() + "/projects/" + ProjectsAPI.getCurrentProjectKey() + "?selectedItem=com.atlassian.jira.jira-projects-plugin:release-page"
                }]],
                selectedItem: selectedVersionId,
                changeViewText: formatter.I18n.getText("project.page.release.subnavigator.change.release"),
                hideSelectedItem: false
            });

            subnavigator.show();
        }
    });
});
