define("jira/projects/release/table-layout-view", [
    "jira/projects/release/templates",
    "jira/util/logger",
    "jira/projects/abstract-list/table-layout-view",
    "jira/projects/release/item-collection-view",
    "jira/projects/abstract-model/submit-model-states",
    "jquery"
], function (
    Templates,
    logger,
    AbstractTableLayoutView,
    ItemCollectionView,
    SubmitModelStates,
    $
) {
    "use strict";

    return AbstractTableLayoutView.extend({
        template: Templates.tableLayout,
        ItemCollectionView: ItemCollectionView,

        onRender: function () {
            AbstractTableLayoutView.prototype.onRender.apply(this, arguments);

            this.makeSortable();
        },

        makeSortable: function () {
            var $items = this.$el.find('tbody.items');
            var preventUpdate = false;

            $items.sortable({
                placeholder: {
                    element: function (item) {
                        return $('<tr class="item-placeholder"><td colspan="' + item.find('td').length + '"></td></tr>')
                            .css("height", item.height() + "px")[0];
                    },
                    update: function (container, p) {
                        return;
                    }
                },
                handle: ".versions-table__handle",
                axis: "y",
                delay: 0,
                containment: "document",
                cursor: "move",
                scroll: true,
                zIndex: 8000,
                update: function (event, ui) {
                    if (preventUpdate) {
                        $items.sortable("cancel");
                        preventUpdate = false;
                        return;
                    }

                    var sourceModel = this.collection.get(ui.item.data("version-id"));
                    var origRefModel = this.collection.at(this.collection.indexOf(sourceModel) + 1);
                    var refModel = this.collection.get(ui.item.nextAll('tr[data-version-id]').first().data("version-id"));

                    if (!sourceModel) {
                        return;
                    }

                    sourceModel.set('state', SubmitModelStates.IN_PROGRESS);

                    sourceModel.sync("move", refModel, {})
                        .done(function () {
                            logger.trace("jira.version.reorder.success");
                        })
                        .fail(function () {
                            this.reorder(sourceModel, origRefModel);
                            logger.trace("jira.version.reorder.failure");
                        }.bind(this))
                        .always(function () {
                            sourceModel.set('state', SubmitModelStates.READY);

                            logger.trace("jira.version.reorder.finished");
                        });


                    this.reorder(sourceModel, refModel);
                }.bind(this),
                helper: function (event, el) {
                    // mind this bug in jquery sortable: // https://bugs.jqueryui.com/ticket/9588
                    var sourceCols = el.find('td');

                    var helper = el.clone();
                    helper = helper.appendTo('body')
                        .wrap('<table class="aui dynamic-table versions-table versions-table__readonly"><tbody class="items"></tbody></table>')
                        .parent().parent().css("left", el.offset().left + "px");

                    helper.find('td').each(function (idx, el) {
                        $(el).css("width", $(sourceCols[idx]).width() + "px");
                    });

                    return helper;
                }
            });

            $(document).keyup(function (event) {
                if (event.keyCode === $.ui.keyCode.ESCAPE) {
                    // unfortunately we can't pass any arguments to `cancel` event
                    preventUpdate = true;
                    $items.sortable("cancel");
                    preventUpdate = false;
                }
            });

            this.listenTo(this.collection, 'add remove destroy', function (model, collection) {
                var sortable = $items.data("sortable");
                if (sortable) {
                    sortable.refresh();
                    if (sortable.helper) {
                        sortable._setContainment();
                    }
                }
            });
        },

        reorder: function (sourceModel, refModel) {
            // prevent scroll reset during re-render of collection
            var scrollTop = $(window).scrollTop();
            this.collection.trigger("reorder", sourceModel, refModel);
            $(window).scrollTop(scrollTop);
        }
    });
});
