AJS.test.require(['com.atlassian.jira.jira-projects-plugin:release-page-assets'], function(){
    "use strict";

    var Marionette = require("jira/projects/libs/marionette");
    var Backbone = require("jira-projects-backbone");
    var $ = require("jquery");
    var SubmitModelStates = require("jira/projects/abstract-model/submit-model-states");

    var Deferred = require("jira/jquery/deferred");

    module('SubmitController', {
        setup: function () {
            this.context = AJS.test.mockableModuleContext();
            this.sandbox = sinon.sandbox.create();
            this.sandbox.useFakeServer();
            this.clock = sinon.useFakeTimers();

            this.modelSave = new Deferred();
            this.modelDetails = new Deferred();
            this.sandbox.stub(Backbone.Model.prototype, "save").returns(this.modelSave);
            Backbone.Model.prototype.detailsSync = this.sandbox.stub().returns(this.modelDetails);

            this.pageableItems = {
                addElement: this.sandbox.stub()
            };

            this.featureManager = {
                isFeatureEnabled: this.sandbox.stub()
            };
            this.flags = {
                showErrorMsg: this.sandbox.stub()
            };

            this.context.mock("jira/featureflags/feature-manager", this.featureManager);
            this.context.mock("jira/projects/release/submit-view", Marionette.ItemView);
            this.context.mock("jira/projects/release/submit-model", Backbone.Model);
            this.context.mock("jira/flag", this.flags);
            this.context.mock("jira/ajs/ajax/ajax-util", this.mockAjaxUtil());

            this.wrmData = {
                claim: sinon.stub()
            };
            this.context.mock("wrm/data", this.wrmData);
            this.wrmData.claim.withArgs("com.atlassian.jira.projects.page.release:projectAdmin").returns(true);

            this.submitController = this.context.require("jira/projects/release/submit-controller");
        },
        teardown: function () {
            this.sandbox.restore();
        },

        mockAjaxUtil: function () {
            return {
                getErrorMessageFromXHR: function(){
                    return "";
                }
            }
        },

        newSubmitView: function () {
            return new this.submitController({
                pageableItems: this.pageableItems
            })
        },

        mockedModel: function() {
            return new Backbone.Model();
        }
    });

    test("SubmitView should be displayed if flag is enabled and user is admin", function () {
        var SubmitController = new this.submitController({isProjectAdmin: true});

        ok(SubmitController.displaySubmitView());
    });

    test("SubmitView should be hidden if user is not admin", function () {
        var SubmitController = new this.submitController({isProjectAdmin: false});

        ok(!SubmitController.displaySubmitView());
    });

    test("New element is added to pageableItems on view save event", function () {
        var submitController = this.newSubmitView();
        var view = submitController.showView();

        view.trigger("save", this.mockedModel());

        ok(this.pageableItems.addElement.calledOnce);
    });

    test("versionAdded should trigger change model state to SubmitModelStates.READY from SubmitModelStates.SUCCESSFUL", function () {
        var submitController = this.newSubmitView();

        var model = submitController.versionAdd(this.mockedModel());
        equal(model.get('state'), SubmitModelStates.IN_PROGRESS);
        this.modelSave.resolve();
        model.set("state", SubmitModelStates.SUCCESSFUL);
        this.modelDetails.resolve();

        this.clock.tick(6000);

        equal(model.get('state'), SubmitModelStates.READY);
    });

    test("versionAdded should NOT trigger change model state to SubmitModelStates.READY from other state than SubmitModelStates.SUCCESSFUL", function () {
        var submitController = this.newSubmitView();

        var model = submitController.versionAdd(this.mockedModel());
        equal(model.get('state'), SubmitModelStates.IN_PROGRESS);
        this.modelSave.resolve();
        this.modelDetails.resolve();
        //simulate user deleting right after component adding
        this.clock.tick(500);
        model.set("state", SubmitModelStates.ERROR_DELETE);
        this.clock.tick(6000);

        equal(model.get('state'), SubmitModelStates.ERROR_DELETE);
    });
});

